/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    private boolean started = false;
    private boolean manuallyOpened = false;
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    protected AbstractMixer(Mixer.Info mixerInfo, Control[] controls, Line.Info[] sourceLineInfo, Line.Info[] targetLineInfo) {
        super(new Line.Info(Mixer.class), null, controls);
        this.mixer = this;
        if (controls == null) {
            controls = new Control[]{};
        }
        this.mixerInfo = mixerInfo;
        this.sourceLineInfo = sourceLineInfo;
        this.targetLineInfo = targetLineInfo;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] localArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, localArray, 0, this.sourceLineInfo.length);
        return localArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] localArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, localArray, 0, this.targetLineInfo.length);
        return localArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        int i;
        Vector<Line.Info> vec = new Vector<Line.Info>();
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            vec.addElement(this.sourceLineInfo[i]);
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        for (i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vec.elementAt(i);
        }
        return returnedArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        int i;
        Vector<Line.Info> vec = new Vector<Line.Info>();
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            vec.addElement(this.targetLineInfo[i]);
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        for (i = 0; i < returnedArray.length; ++i) {
            returnedArray[i] = (Line.Info)vec.elementAt(i);
        }
        return returnedArray;
    }

    public boolean isLineSupported(Line.Info info) {
        int i;
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return true;
        }
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    protected abstract void implOpen() throws LineUnavailableException;

    protected abstract void implStart();

    protected abstract void implStop();

    protected abstract void implClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getSourceLines() {
        Line[] localLines;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            localLines = new Line[this.sourceLines.size()];
            for (int i = 0; i < localLines.length; ++i) {
                localLines[i] = (Line)this.sourceLines.elementAt(i);
            }
        }
        return localLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getTargetLines() {
        Line[] localLines;
        Vector vector = this.targetLines;
        synchronized (vector) {
            localLines = new Line[this.targetLines.size()];
            for (int i = 0; i < localLines.length; ++i) {
                localLines[i] = (Line)this.targetLines.elementAt(i);
            }
        }
        return localLines;
    }

    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    public synchronized void open() throws LineUnavailableException {
        this.open(true);
    }

    protected synchronized void open(boolean manual) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.implOpen();
            this.setOpen(true);
            if (manual) {
                this.manuallyOpened = true;
            }
        }
    }

    protected synchronized void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo()) && !this.targetLines.contains(line)) {
            this.open(false);
            this.targetLines.addElement(line);
        }
    }

    protected synchronized void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.manuallyOpened) {
            this.close();
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            int i;
            Line[] localLines = this.getSourceLines();
            for (i = 0; i < localLines.length; ++i) {
                localLines[i].close();
            }
            localLines = this.getTargetLines();
            for (i = 0; i < localLines.length; ++i) {
                localLines[i].close();
            }
            this.implClose();
            this.setOpen(false);
        }
        this.manuallyOpened = false;
    }

    protected synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.started) {
            this.implStart();
            this.started = true;
        }
    }

    protected synchronized void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector localSourceLines = (Vector)this.sourceLines.clone();
        for (int i = 0; i < localSourceLines.size(); ++i) {
            AbstractDataLine sourceLine;
            if (!(localSourceLines.elementAt(i) instanceof AbstractDataLine) || !(sourceLine = (AbstractDataLine)localSourceLines.elementAt(i)).isStartedRunning() || sourceLine.equals(line)) continue;
            return;
        }
        Vector localTargetLines = (Vector)this.targetLines.clone();
        for (int i = 0; i < localTargetLines.size(); ++i) {
            AbstractDataLine targetLine;
            if (!(localTargetLines.elementAt(i) instanceof AbstractDataLine) || !(targetLine = (AbstractDataLine)localTargetLines.elementAt(i)).isStartedRunning() || targetLine.equals(line)) continue;
            return;
        }
        this.started = false;
        this.implStop();
    }

    boolean isSourceLine(Line.Info info) {
        for (int i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        for (int i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    Line.Info getLineInfo(Line.Info info) {
        int i;
        if (info == null) {
            return null;
        }
        for (i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return this.sourceLineInfo[i];
        }
        for (i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return this.targetLineInfo[i];
        }
        return null;
    }
}

