/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public final class DESedeKeyFactory
extends SecretKeyFactorySpi {
    public DESedeKeyFactory() {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey desEdeKey = null;
        try {
            if (!(keySpec instanceof DESedeKeySpec)) {
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)keySpec;
            desEdeKey = new DESedeKey(desEdeKeySpec.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return desEdeKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (DESedeKeySpec.class.isAssignableFrom(keySpec)) {
                    return new DESedeKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESedeKey) {
                    return key;
                }
                DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)this.engineGetKeySpec(key, (Class)DESedeKeySpec.class);
                return this.engineGenerateSecret(desEdeKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

