/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

class StringCharBuffer
extends CharBuffer {
    CharSequence str;

    StringCharBuffer(CharSequence s, int start, int end) {
        super(-1, start, end, s.length());
        int n = s.length();
        if (start < 0 || start > n || end < start || end > n) {
            throw new IndexOutOfBoundsException();
        }
        this.str = s;
    }

    public CharBuffer slice() {
        return new StringCharBuffer(this.str, -1, 0, this.remaining(), this.remaining(), this.position());
    }

    private StringCharBuffer(CharSequence s, int mark, int pos, int limit, int cap, int offset) {
        super(mark, pos, limit, cap, null, offset);
        this.str = s;
    }

    private StringCharBuffer(CharSequence s, int mark, int pos, int limit, int cap) {
        super(mark, pos, limit, cap);
        this.str = s;
    }

    public CharBuffer duplicate() {
        return new StringCharBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity());
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public final char get() {
        return this.str.charAt(this.nextGetIndex());
    }

    public final char get(int index) {
        return this.str.charAt(this.checkIndex(index));
    }

    public final CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public final boolean isReadOnly() {
        return true;
    }

    final String toString(int start, int end) {
        return ((Object)this.str).toString().substring(start, end);
    }

    public final CharSequence subSequence(int start, int end) {
        try {
            int pos = this.position();
            return new StringCharBuffer(this.str, pos + this.checkIndex(start, pos), pos + this.checkIndex(end, pos));
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean isDirect() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

