/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.ReflectAccess;
import java.security.AccessController;
import sun.reflect.ReflectionFactory;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;

    public static boolean isPublic(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 2) != 0;
    }

    public static boolean isProtected(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isStatic(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isFinal(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isSynchronized(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isVolatile(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isTransient(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isNative(int mod) {
        return (mod & 0x100) != 0;
    }

    public static boolean isInterface(int mod) {
        return (mod & 0x200) != 0;
    }

    public static boolean isAbstract(int mod) {
        return (mod & 0x400) != 0;
    }

    public static boolean isStrict(int mod) {
        return (mod & 0x800) != 0;
    }

    public static String toString(int mod) {
        int len;
        StringBuffer sb = new StringBuffer();
        if ((mod & 1) != 0) {
            sb.append("public ");
        }
        if ((mod & 4) != 0) {
            sb.append("protected ");
        }
        if ((mod & 2) != 0) {
            sb.append("private ");
        }
        if ((mod & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 8) != 0) {
            sb.append("static ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((mod & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((mod & 0x100) != 0) {
            sb.append("native ");
        }
        if ((mod & 0x800) != 0) {
            sb.append("strictfp ");
        }
        if ((mod & 0x200) != 0) {
            sb.append("interface ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "";
    }

    static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    static {
        ReflectionFactory factory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        factory.setLangReflectAccess(new ReflectAccess());
    }
}

