/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanSecurityPropertyAction;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.ReverseBuilder;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderParameters;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIXBuilderParameters buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private X500Principal targetSubjectDN;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;
    private X509CertSelector targetSel;
    private List<CertStore> orderedCertStores;
    private boolean onlyEECert = false;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CertPathBuilderException(e);
        }
        this.onlyEECert = AccessController.doPrivileged(new GetBooleanSecurityPropertyAction("com.sun.security.onlyCheckRevocationOfEECert"));
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        X509Certificate targetCert;
        if (debug != null) {
            debug.println("SunCertPathBuilder.engineBuild(" + params + ")");
        }
        if (!(params instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameter type, must be an instance of PKIXBuilderParameters");
        }
        boolean buildForward = true;
        if (params instanceof SunCertPathBuilderParameters) {
            buildForward = ((SunCertPathBuilderParameters)params).getBuildForward();
        }
        this.buildParams = (PKIXBuilderParameters)params;
        for (TrustAnchor anchor : this.buildParams.getTrustAnchors()) {
            if (anchor.getNameConstraints() == null) continue;
            throw new InvalidAlgorithmParameterException("name constraints in trust anchor not supported");
        }
        CertSelector sel = this.buildParams.getTargetCertConstraints();
        if (!(sel instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("the targetCertConstraints parameter must be an X509CertSelector");
        }
        this.targetSel = (X509CertSelector)sel;
        this.targetSubjectDN = this.targetSel.getSubject();
        if (this.targetSubjectDN == null && (targetCert = this.targetSel.getCertificate()) != null) {
            this.targetSubjectDN = targetCert.getSubjectX500Principal();
        }
        this.orderedCertStores = new ArrayList<CertStore>(this.buildParams.getCertStores());
        Collections.sort(this.orderedCertStores, new CertStoreComparator());
        if (this.targetSubjectDN == null) {
            this.targetSubjectDN = this.getTargetSubjectDN(this.orderedCertStores, this.targetSel);
        }
        if (this.targetSubjectDN == null) {
            throw new InvalidAlgorithmParameterException("Could not determine unique target subject");
        }
        ArrayList<List<Vertex>> adjList = new ArrayList<List<Vertex>>();
        CertPathBuilderResult result = this.buildCertPath(buildForward, false, adjList);
        if (result == null) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild: 2nd pass");
            }
            adjList.clear();
            result = this.buildCertPath(buildForward, true, adjList);
            if (result == null) {
                throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList(adjList));
            }
        }
        return result;
    }

    private CertPathBuilderResult buildCertPath(boolean buildForward, boolean searchAllCertStores, List<List<Vertex>> adjList) throws CertPathBuilderException {
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        LinkedList<X509Certificate> certPathList = new LinkedList<X509Certificate>();
        try {
            if (buildForward) {
                this.buildForward(adjList, certPathList, searchAllCertStores);
            } else {
                this.buildReverse(adjList, certPathList);
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in build");
                e.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", e, new AdjacencyList(adjList));
        }
        try {
            if (this.pathCompleted) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(certPathList);
                return new SunCertPathBuilderResult(this.cf.generateCertPath(certPathList), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList(adjList));
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                e.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", e, new AdjacencyList(adjList));
        }
        return null;
    }

    private void buildReverse(List<List<Vertex>> adjacencyList, LinkedList<X509Certificate> certPathList) throws Exception {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse()...");
            debug.println("SunCertPathBuilder.buildReverse() InitialPolicies: " + this.buildParams.getInitialPolicies());
        }
        ReverseState currentState = new ReverseState();
        adjacencyList.clear();
        adjacencyList.add(new LinkedList());
        Iterator<TrustAnchor> iter = this.buildParams.getTrustAnchors().iterator();
        while (iter.hasNext()) {
            TrustAnchor anchor = iter.next();
            if (this.anchorIsTarget(anchor, this.targetSel)) {
                this.trustAnchor = anchor;
                this.pathCompleted = true;
                this.finalPublicKey = anchor.getTrustedCert().getPublicKey();
                break;
            }
            currentState.initState(this.buildParams.getMaxPathLength(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getCertPathCheckers());
            currentState.updateState(anchor);
            currentState.crlChecker = new CrlRevocationChecker(null, this.buildParams, null, this.onlyEECert);
            try {
                this.depthFirstSearchReverse(null, currentState, new ReverseBuilder(this.buildParams, this.targetSubjectDN), adjacencyList, certPathList);
                break;
            }
            catch (Exception e) {
                if (iter.hasNext()) continue;
                throw e;
            }
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() returned from depthFirstSearchReverse()");
            debug.println("SunCertPathBuilder.buildReverse() certPathList.size: " + certPathList.size());
        }
    }

    private void buildForward(List<List<Vertex>> adjacencyList, LinkedList<X509Certificate> certPathList, boolean searchAllCertStores) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState currentState = new ForwardState();
        currentState.initState(this.buildParams.getCertPathCheckers());
        adjacencyList.clear();
        adjacencyList.add(new LinkedList());
        currentState.crlChecker = new CrlRevocationChecker(null, this.buildParams, null, this.onlyEECert);
        this.depthFirstSearchForward(this.targetSubjectDN, currentState, new ForwardBuilder(this.buildParams, this.targetSubjectDN, searchAllCertStores, this.onlyEECert), adjacencyList, certPathList);
    }

    void depthFirstSearchForward(X500Principal dN, ForwardState currentState, ForwardBuilder builder, List<List<Vertex>> adjList, LinkedList<X509Certificate> certPathList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + dN + ", " + currentState.toString() + ")");
        }
        List<Vertex> vertices = this.addVertices(builder.getMatchingCerts(currentState, this.orderedCertStores), adjList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + vertices.size());
        }
        block4: for (Vertex vertex : vertices) {
            ForwardState nextState = (ForwardState)currentState.clone();
            X509Certificate cert = (X509Certificate)vertex.getCertificate();
            try {
                builder.verifyCert(cert, nextState, certPathList);
            }
            catch (GeneralSecurityException gse) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + gse);
                    gse.printStackTrace();
                }
                vertex.setThrowable(gse);
                continue;
            }
            if (builder.isPathCompleted(cert)) {
                BasicChecker basicChecker = null;
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                ArrayList<X509Certificate> appendedCerts = new ArrayList<X509Certificate>(certPathList);
                if (builder.trustAnchor.getTrustedCert() == null) {
                    appendedCerts.add(0, cert);
                }
                HashSet<String> initExpPolSet = new HashSet<String>(1);
                initExpPolSet.add("2.5.29.32.0");
                PolicyNodeImpl rootNode = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, initExpPolSet, false);
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.getInitialPolicies(), appendedCerts.size(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getPolicyQualifiersRejected(), rootNode);
                ArrayList<PKIXCertPathChecker> userCheckers = new ArrayList<PKIXCertPathChecker>(this.buildParams.getCertPathCheckers());
                int mustCheck = 0;
                userCheckers.add(mustCheck, policyChecker);
                ++mustCheck;
                if (nextState.keyParamsNeeded()) {
                    PublicKey rootKey = cert.getPublicKey();
                    if (builder.trustAnchor.getTrustedCert() == null) {
                        rootKey = builder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + rootKey.toString());
                        }
                    }
                    TrustAnchor anchor = new TrustAnchor(cert.getSubjectX500Principal(), rootKey, null);
                    basicChecker = new BasicChecker(anchor, builder.date, this.buildParams.getSigProvider(), true);
                    userCheckers.add(mustCheck, basicChecker);
                    ++mustCheck;
                    if (this.buildParams.isRevocationEnabled()) {
                        userCheckers.add(mustCheck, new CrlRevocationChecker(anchor, this.buildParams, null, this.onlyEECert));
                        ++mustCheck;
                    }
                }
                for (int i = 0; i < appendedCerts.size(); ++i) {
                    Set<String> unresCritExts;
                    X509Certificate currCert = appendedCerts.get(i);
                    if (debug != null) {
                        debug.println("current subject = " + currCert.getSubjectX500Principal());
                    }
                    if ((unresCritExts = currCert.getCriticalExtensionOIDs()) == null) {
                        unresCritExts = Collections.emptySet();
                    }
                    for (int j = 0; j < userCheckers.size(); ++j) {
                        PKIXCertPathChecker currChecker = (PKIXCertPathChecker)userCheckers.get(j);
                        if (j >= mustCheck && currChecker.isForwardCheckingSupported()) continue;
                        if (i == 0) {
                            currChecker.init(false);
                        }
                        try {
                            currChecker.check(currCert, unresCritExts);
                            continue;
                        }
                        catch (CertPathValidatorException cpve) {
                            if (debug != null) {
                                debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + cpve);
                            }
                            vertex.setThrowable(cpve);
                            continue block4;
                        }
                    }
                    for (PKIXCertPathChecker checker : this.buildParams.getCertPathCheckers()) {
                        Set<String> suppExts;
                        if (!checker.isForwardCheckingSupported() || (suppExts = checker.getSupportedExtensions()) == null) continue;
                        unresCritExts.removeAll(suppExts);
                    }
                    if (unresCritExts.isEmpty()) continue;
                    unresCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                    unresCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
                    unresCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                    unresCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                    unresCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                    unresCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
                    unresCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                    if (unresCritExts.isEmpty()) continue;
                    throw new CertPathValidatorException("unrecognized critical extension(s)");
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (builder.trustAnchor.getTrustedCert() == null) {
                    builder.addCertToPath(cert, certPathList);
                }
                this.trustAnchor = builder.trustAnchor;
                if (basicChecker != null) {
                    this.finalPublicKey = basicChecker.getPublicKey();
                } else {
                    Certificate finalCert = certPathList.size() == 0 ? builder.trustAnchor.getTrustedCert() : (Certificate)certPathList.get(certPathList.size() - 1);
                    this.finalPublicKey = finalCert.getPublicKey();
                }
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            builder.addCertToPath(cert, certPathList);
            nextState.updateState(cert);
            adjList.add(new LinkedList());
            vertex.setIndex(adjList.size() - 1);
            this.depthFirstSearchForward(cert.getIssuerX500Principal(), nextState, builder, adjList, certPathList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            builder.removeFinalCertFromPath(certPathList);
        }
    }

    void depthFirstSearchReverse(X500Principal dN, ReverseState currentState, ReverseBuilder builder, List<List<Vertex>> adjList, LinkedList<X509Certificate> certPathList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(" + dN + ", " + currentState.toString() + ")");
        }
        List<Vertex> vertices = this.addVertices(builder.getMatchingCerts(currentState, this.orderedCertStores), adjList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(): certs.size=" + vertices.size());
        }
        for (Vertex vertex : vertices) {
            ReverseState nextState = (ReverseState)currentState.clone();
            X509Certificate cert = (X509Certificate)vertex.getCertificate();
            try {
                builder.verifyCert(cert, nextState, certPathList);
            }
            catch (GeneralSecurityException gse) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): validation failed: " + gse);
                }
                vertex.setThrowable(gse);
                continue;
            }
            if (!currentState.isInitial()) {
                builder.addCertToPath(cert, certPathList);
            }
            this.trustAnchor = currentState.trustAnchor;
            if (builder.isPathCompleted(cert)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): path completed!");
                }
                this.pathCompleted = true;
                PolicyNodeImpl rootNode = nextState.rootNode;
                if (rootNode == null) {
                    this.policyTreeResult = null;
                } else {
                    this.policyTreeResult = rootNode.copyTree();
                    ((PolicyNodeImpl)this.policyTreeResult).setImmutable();
                }
                this.finalPublicKey = cert.getPublicKey();
                if (this.finalPublicKey instanceof DSAPublicKey && ((DSAPublicKey)this.finalPublicKey).getParams() == null) {
                    this.finalPublicKey = BasicChecker.makeInheritedParamsKey(this.finalPublicKey, currentState.pubKey);
                }
                return;
            }
            nextState.updateState(cert);
            adjList.add(new LinkedList());
            vertex.setIndex(adjList.size() - 1);
            this.depthFirstSearchReverse(cert.getSubjectX500Principal(), nextState, builder, adjList, certPathList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchReverse(): backtracking");
            }
            if (currentState.isInitial()) continue;
            builder.removeFinalCertFromPath(certPathList);
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse() all certs in this adjacency list checked");
        }
    }

    private List<Vertex> addVertices(Collection<X509Certificate> certs, List<List<Vertex>> adjList) {
        List<Vertex> l = adjList.get(adjList.size() - 1);
        for (X509Certificate cert : certs) {
            Vertex v = new Vertex(cert);
            l.add(v);
        }
        return l;
    }

    private boolean anchorIsTarget(TrustAnchor anchor, X509CertSelector sel) {
        X509Certificate anchorCert = anchor.getTrustedCert();
        if (anchorCert != null) {
            return sel.match(anchorCert);
        }
        return false;
    }

    private X500Principal getTargetSubjectDN(List<CertStore> stores, X509CertSelector targetSel) {
        for (CertStore store : stores) {
            try {
                Collection<? extends Certificate> targetCerts = store.getCertificates(targetSel);
                if (targetCerts.isEmpty()) continue;
                X509Certificate targetCert = (X509Certificate)targetCerts.iterator().next();
                return targetCert.getSubjectX500Principal();
            }
            catch (CertStoreException e) {
                if (debug == null) continue;
                debug.println("SunCertPathBuilder.getTargetSubjectDN: non-fatal exception retrieving certs: " + e);
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertStoreComparator
    implements Comparator<CertStore> {
        private CertStoreComparator() {
        }

        @Override
        public int compare(CertStore store1, CertStore store2) {
            if (Builder.isLocalCertStore(store1)) {
                return -1;
            }
            return 1;
        }
    }
}

