/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.net.MalformedURLException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PolicySpi;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import sun.security.provider.PolicyFile;

public final class PolicySpiFile
extends PolicySpi {
    private PolicyFile pf;

    public PolicySpiFile(Policy.Parameters params) {
        if (params == null) {
            this.pf = new PolicyFile();
        } else {
            if (!(params instanceof URIParameter)) {
                throw new IllegalArgumentException("Unrecognized policy parameter: " + params);
            }
            URIParameter uriParam = (URIParameter)params;
            try {
                this.pf = new PolicyFile(uriParam.getURI().toURL());
            }
            catch (MalformedURLException mue) {
                throw new IllegalArgumentException("Invalid URIParameter", mue);
            }
        }
    }

    protected PermissionCollection engineGetPermissions(CodeSource codesource) {
        return this.pf.getPermissions(codesource);
    }

    protected PermissionCollection engineGetPermissions(ProtectionDomain d) {
        return this.pf.getPermissions(d);
    }

    protected boolean engineImplies(ProtectionDomain d, Permission p) {
        return this.pf.implies(d, p);
    }

    protected void engineRefresh() {
        this.pf.refresh();
    }
}

