/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.InputStream;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.http.Hurryable;

public class ChunkedInputStream
extends InputStream
implements Hurryable {
    private InputStream in;
    private HttpClient hc;
    private MessageHeader responses;
    private int chunkSize;
    private int chunkRead;
    private byte[] chunkData = new byte[4096];
    private int chunkPos;
    private int chunkCount;
    private byte[] rawData = new byte[32];
    private int rawPos;
    private int rawCount;
    private boolean error;
    private boolean closed;
    static final int STATE_AWAITING_CHUNK_HEADER = 1;
    static final int STATE_READING_CHUNK = 2;
    static final int STATE_AWAITING_CHUNK_EOL = 3;
    static final int STATE_AWAITING_TRAILERS = 4;
    static final int STATE_DONE = 5;
    private int state;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
    }

    private void ensureRawAvailable(int size) {
        if (this.rawCount + size > this.rawData.length) {
            int used = this.rawCount - this.rawPos;
            if (used + size > this.rawData.length) {
                byte[] tmp = new byte[used + size];
                if (used > 0) {
                    System.arraycopy(this.rawData, this.rawPos, tmp, 0, used);
                }
                this.rawData = tmp;
            } else if (used > 0) {
                System.arraycopy(this.rawData, this.rawPos, this.rawData, 0, used);
            }
            this.rawCount = used;
            this.rawPos = 0;
        }
    }

    private void closeUnderlying() throws IOException {
        if (this.in == null) {
            return;
        }
        if (!this.error && this.state == 5) {
            this.hc.finished();
        } else if (!this.hurry()) {
            this.hc.closeServer();
        }
        this.in = null;
    }

    private int fastRead(byte[] b, int off, int len) throws IOException {
        int cnt;
        int remaining = this.chunkSize - this.chunkRead;
        int n = cnt = remaining < len ? remaining : len;
        if (cnt > 0) {
            int nread;
            try {
                nread = this.in.read(b, off, cnt);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
            if (nread > 0) {
                this.chunkRead += nread;
                if (this.chunkRead >= this.chunkSize) {
                    this.state = 3;
                }
                return nread;
            }
            this.error = true;
            throw new IOException("Premature EOF");
        }
        return 0;
    }

    private void processRaw() throws IOException {
        while (this.state != 5) {
            switch (this.state) {
                case 1: {
                    int i;
                    int pos;
                    for (pos = this.rawPos; pos < this.rawCount && this.rawData[pos] != 10; ++pos) {
                    }
                    if (pos >= this.rawCount) {
                        return;
                    }
                    String header = new String(this.rawData, this.rawPos, pos - this.rawPos + 1, "US-ASCII");
                    for (i = 0; i < header.length() && Character.digit(header.charAt(i), 16) != -1; ++i) {
                    }
                    try {
                        this.chunkSize = Integer.parseInt(header.substring(0, i), 16);
                    }
                    catch (NumberFormatException e) {
                        this.error = true;
                        throw new IOException("Bogus chunk size");
                    }
                    this.rawPos = pos + 1;
                    this.chunkRead = 0;
                    if (this.chunkSize > 0) {
                        this.state = 2;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                case 2: {
                    if (this.rawPos >= this.rawCount) {
                        return;
                    }
                    int copyLen = Math.min(this.chunkSize - this.chunkRead, this.rawCount - this.rawPos);
                    if (this.chunkData.length < this.chunkCount + copyLen) {
                        int cnt = this.chunkCount - this.chunkPos;
                        if (this.chunkData.length < cnt + copyLen) {
                            byte[] tmp = new byte[cnt + copyLen];
                            System.arraycopy(this.chunkData, this.chunkPos, tmp, 0, cnt);
                            this.chunkData = tmp;
                        } else {
                            System.arraycopy(this.chunkData, this.chunkPos, this.chunkData, 0, cnt);
                        }
                        this.chunkPos = 0;
                        this.chunkCount = cnt;
                    }
                    System.arraycopy(this.rawData, this.rawPos, this.chunkData, this.chunkCount, copyLen);
                    this.rawPos += copyLen;
                    this.chunkCount += copyLen;
                    this.chunkRead += copyLen;
                    if (this.chunkSize - this.chunkRead <= 0) {
                        this.state = 3;
                        break;
                    }
                    return;
                }
                case 3: {
                    if (this.rawPos + 1 >= this.rawCount) {
                        return;
                    }
                    if (this.rawData[this.rawPos] != 13) {
                        this.error = true;
                        throw new IOException("missing CR");
                    }
                    if (this.rawData[this.rawPos + 1] != 10) {
                        this.error = true;
                        throw new IOException("missing LF");
                    }
                    this.rawPos += 2;
                    this.state = 1;
                    break;
                }
                case 4: {
                    int pos;
                    for (pos = this.rawPos; pos < this.rawCount && this.rawData[pos] != 10; ++pos) {
                    }
                    if (pos >= this.rawCount) {
                        return;
                    }
                    if (pos == this.rawPos) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (this.rawData[pos - 1] != 13) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (pos == this.rawPos + 1) {
                        this.state = 5;
                        this.closeUnderlying();
                        return;
                    }
                    String trailer = new String(this.rawData, this.rawPos, pos - this.rawPos, "US-ASCII");
                    int i = trailer.indexOf(58);
                    if (i == -1) {
                        throw new IOException("Malformed tailer - format should be key:value");
                    }
                    String key = trailer.substring(0, i).trim();
                    String value = trailer.substring(i + 1, trailer.length()).trim();
                    this.responses.add(key, value);
                    this.rawPos = pos + 1;
                }
            }
        }
    }

    private int readAheadNonBlocking() throws IOException {
        int avail = this.in.available();
        if (avail > 0) {
            int nread;
            this.ensureRawAvailable(avail);
            try {
                nread = this.in.read(this.rawData, this.rawCount, avail);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
            if (nread < 0) {
                this.error = true;
                return -1;
            }
            this.rawCount += nread;
            this.processRaw();
        }
        return this.chunkCount - this.chunkPos;
    }

    private int readAheadBlocking() throws IOException {
        do {
            int nread;
            if (this.state == 5) {
                return -1;
            }
            this.ensureRawAvailable(32);
            try {
                nread = this.in.read(this.rawData, this.rawCount, this.rawData.length - this.rawCount);
            }
            catch (IOException e) {
                this.error = true;
                throw e;
            }
            if (nread < 0) {
                this.error = true;
                throw new IOException("Premature EOF");
            }
            this.rawCount += nread;
            this.processRaw();
        } while (this.chunkCount <= 0);
        return this.chunkCount - this.chunkPos;
    }

    private int readAhead(boolean allowBlocking) throws IOException {
        if (this.state == 5) {
            return -1;
        }
        if (this.chunkPos >= this.chunkCount) {
            this.chunkCount = 0;
            this.chunkPos = 0;
        }
        if (allowBlocking) {
            return this.readAheadBlocking();
        }
        return this.readAheadNonBlocking();
    }

    public ChunkedInputStream(InputStream in, HttpClient hc, MessageHeader responses) throws IOException {
        this.in = in;
        this.responses = responses;
        this.hc = hc;
        this.state = 1;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.chunkPos >= this.chunkCount && this.readAhead(true) <= 0) {
            return -1;
        }
        return this.chunkData[this.chunkPos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int avail = this.chunkCount - this.chunkPos;
        if (avail <= 0) {
            if (this.state == 2) {
                return this.fastRead(b, off, len);
            }
            avail = this.readAhead(true);
            if (avail < 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.chunkData, this.chunkPos, b, off, cnt);
        this.chunkPos += cnt;
        return cnt;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        int avail = this.chunkCount - this.chunkPos;
        if (avail > 0) {
            return avail;
        }
        avail = this.readAhead(false);
        if (avail < 0) {
            return 0;
        }
        return avail;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closeUnderlying();
        this.closed = true;
    }

    public synchronized boolean hurry() {
        if (this.in == null || this.error) {
            return false;
        }
        try {
            this.readAhead(false);
        }
        catch (Exception e) {
            return false;
        }
        if (this.error) {
            return false;
        }
        return this.state == 5;
    }
}

