/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Line;

public interface Port
extends Line {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends Line.Info {
        public static final Info MICROPHONE = new Info(Port.class, "MICROPHONE", true);
        public static final Info LINE_IN = new Info(Port.class, "LINE_IN", true);
        public static final Info COMPACT_DISC = new Info(Port.class, "COMPACT_DISC", true);
        public static final Info SPEAKER = new Info(Port.class, "SPEAKER", false);
        public static final Info HEADPHONE = new Info(Port.class, "HEADPHONE", false);
        public static final Info LINE_OUT = new Info(Port.class, "LINE_OUT", false);
        private String name;
        private boolean isSource;

        public Info(Class<?> lineClass, String name, boolean isSource) {
            super(lineClass);
            this.name = name;
            this.isSource = isSource;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSource() {
            return this.isSource;
        }

        @Override
        public boolean matches(Line.Info info) {
            if (!super.matches(info)) {
                return false;
            }
            if (!this.name.equals(((Info)info).getName())) {
                return false;
            }
            return this.isSource == ((Info)info).isSource();
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        @Override
        public final String toString() {
            return this.name + (this.isSource ? " source" : " target") + " port";
        }
    }
}

