/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

abstract class ByteToCharDBCS_ONLY_EBCDIC
extends ByteToCharConverter {
    private boolean savedBytePresent = false;
    private byte savedByte;
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedBytePresent) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int outputChar = 65533;
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int inputSize;
            int byte1;
            if (!this.savedBytePresent) {
                byte1 = input[this.byteOff] & 0xFF;
                inputSize = 1;
            } else {
                byte1 = this.savedByte;
                this.savedBytePresent = false;
                inputSize = 0;
            }
            if (byte1 < 64 || byte1 > 254) {
                this.badInputLength = 1;
                throw new MalformedInputException();
            }
            if (this.byteOff + inputSize >= inEnd) {
                this.savedByte = (byte)byte1;
                this.savedBytePresent = true;
                this.byteOff += inputSize;
                break;
            }
            int byte2 = input[this.byteOff + inputSize] & 0xFF;
            ++inputSize;
            if (!(byte1 == 64 && byte2 == 64 || byte2 >= 65 && byte2 <= 254)) {
                this.badInputLength = 2;
                throw new MalformedInputException();
            }
            int v = byte1 * 256 + byte2;
            outputChar = this.index2.charAt(this.index1[(v & this.mask1) >> this.shift] + (v & this.mask2));
            if (outputChar == 65533) {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            output[this.charOff++] = outputChar;
            this.byteOff += inputSize;
        }
        return this.charOff - outOff;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.savedBytePresent = false;
    }
}

