/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class EPollArrayWrapper {
    static final int EPOLLIN = 1;
    static final int EPOLL_CTL_ADD = 1;
    static final int EPOLL_CTL_DEL = 2;
    static final int EPOLL_CTL_MOD = 3;
    static final int SIZE_EPOLLEVENT = EPollArrayWrapper.sizeofEPollEvent();
    static final int EVENT_OFFSET = 0;
    static final int DATA_OFFSET;
    static final int FD_OFFSET;
    static final int NUM_EPOLLEVENTS;
    private final long pollArrayAddress;
    private final HashSet<Integer> idleSet;
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    final int epfd = this.epollCreate();
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    EPollArrayWrapper() {
        int allocationSize = NUM_EPOLLEVENTS * SIZE_EPOLLEVENT;
        this.pollArray = new AllocatedNativeObject(allocationSize, true);
        this.pollArrayAddress = this.pollArray.address();
        for (int i = 0; i < NUM_EPOLLEVENTS; ++i) {
            this.putEventOps(i, 0);
            this.putData(i, 0L);
        }
        this.idleSet = new HashSet();
    }

    void initInterrupt(int fd0, int fd1) {
        this.outgoingInterruptFD = fd1;
        this.incomingInterruptFD = fd0;
        this.epollCtl(this.epfd, 1, fd0, 1);
    }

    void putEventOps(int i, int event) {
        int offset = SIZE_EPOLLEVENT * i + 0;
        this.pollArray.putInt(offset, event);
    }

    void putData(int i, long value) {
        int offset = SIZE_EPOLLEVENT * i + DATA_OFFSET;
        this.pollArray.putLong(offset, value);
    }

    void putDescriptor(int i, int fd) {
        int offset = SIZE_EPOLLEVENT * i + FD_OFFSET;
        this.pollArray.putInt(offset, fd);
    }

    int getEventOps(int i) {
        int offset = SIZE_EPOLLEVENT * i + 0;
        return this.pollArray.getInt(offset);
    }

    int getDescriptor(int i) {
        int offset = SIZE_EPOLLEVENT * i + FD_OFFSET;
        return this.pollArray.getInt(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int fd, int mask) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            if (mask == 0) {
                if (this.idleSet.add(fd)) {
                    this.updateList.add(new Updator(2, fd, 0));
                }
                return;
            }
            if (!this.idleSet.isEmpty() && this.idleSet.remove(fd)) {
                this.updateList.add(new Updator(1, fd, mask));
                return;
            }
            if (this.updateList.size() > 0) {
                Updator last = this.updateList.getLast();
                if (last.fd == fd && last.opcode == 1) {
                    last.events = mask;
                    return;
                }
            }
            this.updateList.add(new Updator(3, fd, mask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int fd) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(1, fd, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int fd) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            if (!this.idleSet.remove(fd)) {
                this.updateList.add(new Updator(2, fd, 0));
            }
        }
    }

    void closeEPollFD() throws IOException {
        FileDispatcher.closeIntFD(this.epfd);
        this.pollArray.free();
    }

    int poll(long timeout) throws IOException {
        this.updateRegistrations();
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, timeout, this.epfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            Updator u = null;
            while ((u = this.updateList.poll()) != null) {
                this.epollCtl(this.epfd, u.opcode, u.fd, u.events);
            }
        }
    }

    public void interrupt() {
        EPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int epollCreate();

    private native void epollCtl(int var1, int var2, int var3, int var4);

    private native int epollWait(long var1, int var3, long var4, int var6) throws IOException;

    private static native int sizeofEPollEvent();

    private static native int offsetofData();

    private static native int fdLimit();

    private static native void interrupt(int var0);

    private static native void init();

    static {
        FD_OFFSET = DATA_OFFSET = EPollArrayWrapper.offsetofData();
        NUM_EPOLLEVENTS = Math.min(EPollArrayWrapper.fdLimit(), 8192);
        EPollArrayWrapper.init();
    }

    private static class Updator {
        int opcode;
        int fd;
        int events;

        Updator(int opcode, int fd, int events) {
            this.opcode = opcode;
            this.fd = fd;
            this.events = events;
        }
    }
}

