/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.BreakIterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.WindowAccessor;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;

public class XTrayIconPeer
implements TrayIconPeer {
    private static final Logger ctrLog = Logger.getLogger("sun.awt.X11.XTrayIconPeer.centering");
    TrayIcon target;
    TrayIconEventProxy eventProxy;
    XTrayIconEmbeddedFrame eframe;
    TrayIconCanvas canvas;
    Balloon balloon;
    Tooltip tooltip;
    PopupMenu popup;
    String tooltipString;
    boolean isTrayIconDisplayed;
    long eframeParentID;
    final XEventDispatcher parentXED;
    final XEventDispatcher eframeXED;
    static final XEventDispatcher dummyXED = new XEventDispatcher(){

        public void dispatchEvent(XEvent ev) {
        }
    };
    volatile boolean isDisposed;
    boolean isParentWindowLocated;
    int old_x;
    int old_y;
    int ex_width;
    int ex_height;
    static final int TRAY_ICON_WIDTH = 24;
    static final int TRAY_ICON_HEIGHT = 24;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XTrayIconPeer(TrayIcon target) throws AWTException {
        this.target = target;
        this.eventProxy = new TrayIconEventProxy(this);
        this.canvas = new TrayIconCanvas(target, 24, 24);
        this.eframe = new XTrayIconEmbeddedFrame();
        this.eframe.setSize(24, 24);
        this.eframe.add(this.canvas);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                XTrayIconPeer.this.eframe.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
                return null;
            }
        });
        this.parentXED = XWM.getWMID() != 11 ? dummyXED : new XEventDispatcher(){

            public void dispatchEvent(XEvent ev) {
                if (XTrayIconPeer.this.isDisposed() || ev.get_type() != 22) {
                    return;
                }
                XConfigureEvent ce = ev.get_xconfigure();
                ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}: {1}x{2}+{3}+{4} (old: {5}+{6})", new Object[]{XTrayIconPeer.this, ce.get_width(), ce.get_height(), ce.get_x(), ce.get_y(), XTrayIconPeer.this.old_x, XTrayIconPeer.this.old_y});
                if (ce.get_height() != 24 && ce.get_width() != 24) {
                    ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Skipping as intermediate resizing.", XTrayIconPeer.this);
                    return;
                }
                if (ce.get_height() > 24) {
                    ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Centering by \"Y\".", XTrayIconPeer.this);
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x(), ce.get_y() + ce.get_height() / 2 - 12, 24, 24);
                    XTrayIconPeer.this.ex_height = ce.get_height();
                    XTrayIconPeer.this.ex_width = 0;
                } else if (ce.get_width() > 24) {
                    ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Centering by \"X\".", XTrayIconPeer.this);
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x() + ce.get_width() / 2 - 12, ce.get_y(), 24, 24);
                    XTrayIconPeer.this.ex_width = ce.get_width();
                    XTrayIconPeer.this.ex_height = 0;
                } else if (XTrayIconPeer.this.isParentWindowLocated && ce.get_x() != XTrayIconPeer.this.old_x && ce.get_y() != XTrayIconPeer.this.old_y) {
                    if (XTrayIconPeer.this.ex_height != 0) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Centering by \"Y\".", XTrayIconPeer.this);
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x(), ce.get_y() + XTrayIconPeer.this.ex_height / 2 - 12);
                    } else if (XTrayIconPeer.this.ex_width != 0) {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Centering by \"X\".", XTrayIconPeer.this);
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x() + XTrayIconPeer.this.ex_width / 2 - 12, ce.get_y());
                    } else {
                        ctrLog.log(Level.FINE, "ConfigureNotify on parent of {0}. Move detected. Skipping.", XTrayIconPeer.this);
                    }
                }
                XTrayIconPeer.this.old_x = ce.get_x();
                XTrayIconPeer.this.old_y = ce.get_y();
                XTrayIconPeer.this.isParentWindowLocated = true;
            }
        };
        this.eframeXED = new XEventDispatcher(){
            XTrayIconPeer xtiPeer;
            {
                this.xtiPeer = XTrayIconPeer.this;
            }

            public void dispatchEvent(XEvent ev) {
                if (XTrayIconPeer.this.isDisposed() || ev.get_type() != 21) {
                    return;
                }
                XReparentEvent re = ev.get_xreparent();
                XTrayIconPeer.this.eframeParentID = re.get_parent();
                if (XTrayIconPeer.this.eframeParentID == XToolkit.getDefaultRootWindow()) {
                    if (XTrayIconPeer.this.isTrayIconDisplayed) {
                        SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                            public void run() {
                                SystemTray.getSystemTray().remove(xtiPeer.target);
                            }
                        });
                    }
                    return;
                }
                if (!XTrayIconPeer.this.isTrayIconDisplayed) {
                    XTrayIconPeer.this.addXED(XTrayIconPeer.this.eframeParentID, XTrayIconPeer.this.parentXED, 131072L);
                    XTrayIconPeer.this.isTrayIconDisplayed = true;
                    XToolkit.awtLockNotifyAll();
                }
            }
        };
        this.addXED(this.getWindow(), this.eframeXED, 131072L);
        XSystemTrayPeer.getPeerInstance().addTrayIcon(this);
        long start = System.currentTimeMillis();
        long PERIOD = 2000L;
        XToolkit.awtLock();
        try {
            while (!this.isTrayIconDisplayed) {
                try {
                    XToolkit.awtLockWait(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - start <= 2000L) continue;
                break;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (!this.isTrayIconDisplayed || this.eframeParentID == 0L || this.eframeParentID == XToolkit.getDefaultRootWindow()) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        this.eframe.setVisible(true);
        this.updateImage();
        this.balloon = new Balloon(this, this.eframe);
        this.tooltip = new Tooltip(this, this.eframe);
        this.addListeners();
    }

    public void dispose() {
        if (SunToolkit.isDispatchThreadForAppContext(this.target)) {
            this.disposeOnEDT();
        } else {
            try {
                SunToolkit.executeOnEDTAndWait(this.target, new Runnable(){

                    public void run() {
                        XTrayIconPeer.this.disposeOnEDT();
                    }
                });
            }
            catch (InterruptedException ie) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void disposeOnEDT() {
        XToolkit.awtLock();
        this.isDisposed = true;
        XToolkit.awtUnlock();
        this.removeXED(this.getWindow(), this.eframeXED);
        this.removeXED(this.eframeParentID, this.parentXED);
        this.eframe.realDispose();
        this.balloon.dispose();
        this.isTrayIconDisplayed = false;
        XToolkit.targetDisposedPeer(this.target, this);
    }

    public static void suppressWarningString(Window w) {
        WindowAccessor.setTrayIconWindow(w, true);
    }

    public void setToolTip(String tooltip) {
        this.tooltipString = tooltip;
    }

    public void updateImage() {
        Runnable r = new Runnable(){

            public void run() {
                XTrayIconPeer.this.canvas.updateImage(XTrayIconPeer.this.target.getImage());
            }
        };
        if (!SunToolkit.isDispatchThreadForAppContext(this.target)) {
            SunToolkit.executeOnEventHandlerThread(this.target, r);
        } else {
            r.run();
        }
    }

    public void displayMessage(String caption, String text, String messageType) {
        Point loc = this.getLocationOnScreen();
        Rectangle screen = this.eframe.getGraphicsConfiguration().getBounds();
        if (loc.x >= screen.x && loc.x < screen.x + screen.width && loc.y >= screen.y && loc.y < screen.y + screen.height) {
            this.balloon.display(caption, text, messageType);
        }
    }

    public void showPopupMenu(int x, int y) {
        if (this.isDisposed()) {
            return;
        }
        assert (SunToolkit.isDispatchThreadForAppContext(this.target));
        PopupMenu newPopup = this.target.getPopupMenu();
        if (this.popup != newPopup) {
            if (this.popup != null) {
                this.eframe.remove(this.popup);
            }
            if (newPopup != null) {
                this.eframe.add(newPopup);
            }
            this.popup = newPopup;
        }
        if (this.popup != null) {
            Point loc = ((XBaseWindow)((Object)this.eframe.getPeer())).toLocal(new Point(x, y));
            this.popup.show(this.eframe, loc.x, loc.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXED(long window, XEventDispatcher xed, long mask) {
        if (window == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), window, mask);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XToolkit.addEventDispatcher(window, xed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXED(long window, XEventDispatcher xed) {
        if (window == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XToolkit.removeEventDispatcher(window, xed);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private Point getLocationOnScreen() {
        return this.eframe.getLocationOnScreen();
    }

    private Rectangle getBounds() {
        Point loc = this.getLocationOnScreen();
        return new Rectangle(loc.x, loc.y, loc.x + 24, loc.y + 24);
    }

    void addListeners() {
        this.canvas.addMouseListener(this.eventProxy);
        this.canvas.addMouseMotionListener(this.eventProxy);
    }

    long getWindow() {
        return ((XEmbeddedFramePeer)this.eframe.getPeer()).getWindow();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    static boolean isTrayIconStuffWindow(Window w) {
        return w instanceof Tooltip || w instanceof Balloon || w instanceof XTrayIconEmbeddedFrame;
    }

    static class InfoWindow
    extends Window {
        Container container = new Container(){

            public Insets getInsets() {
                return new Insets(1, 1, 1, 1);
            }
        };
        Closer closer;

        InfoWindow(Frame parent, Color borderColor) {
            super(parent);
            this.setLayout(new BorderLayout());
            this.setBackground(borderColor);
            this.add((Component)this.container, "Center");
            this.container.setLayout(new BorderLayout());
            this.closer = new Closer();
        }

        public Component add(Component c) {
            this.container.add(c, "Center");
            return c;
        }

        void setCloser(Runnable action, int time) {
            this.closer.set(action, time);
        }

        protected void show(Point corner, int indent) {
            assert (SunToolkit.isDispatchThreadForAppContext(this));
            this.pack();
            Dimension size = this.getSize();
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (corner.x < scrSize.width / 2 && corner.y < scrSize.height / 2) {
                this.setLocation(corner.x + indent, corner.y + indent);
            } else if (corner.x >= scrSize.width / 2 && corner.y < scrSize.height / 2) {
                this.setLocation(corner.x - indent - size.width, corner.y + indent);
            } else if (corner.x < scrSize.width / 2 && corner.y >= scrSize.height / 2) {
                this.setLocation(corner.x + indent, corner.y - indent - size.height);
            } else if (corner.x >= scrSize.width / 2 && corner.y >= scrSize.height / 2) {
                this.setLocation(corner.x - indent - size.width, corner.y - indent - size.height);
            }
            InfoWindow.super.show();
            this.closer.schedule();
        }

        public void hide() {
            this.closer.close();
        }

        class Closer
        implements Runnable {
            Runnable action;
            int time;

            Closer() {
            }

            public void run() {
                this.doClose();
            }

            void set(Runnable action, int time) {
                this.action = action;
                this.time = time;
            }

            void schedule() {
                XToolkit.schedule(this, this.time);
            }

            void close() {
                XToolkit.remove(this);
                this.doClose();
            }

            private void doClose() {
                SunToolkit.executeOnEventHandlerThread(InfoWindow.this, new Runnable(){

                    public void run() {
                        InfoWindow.super.hide();
                        InfoWindow.this.invalidate();
                        if (Closer.this.action != null) {
                            Closer.this.action.run();
                        }
                    }
                });
            }
        }
    }

    static class Balloon
    extends InfoWindow {
        static final int BALLOON_SHOW_TIME = 10000;
        static final int BALLOON_TEXT_MAX_LENGTH = 256;
        static final int BALLOON_WORD_LINE_MAX_LENGTH = 16;
        static final int BALLOON_WORD_LINE_MAX_COUNT = 4;
        static final int BALLOON_ICON_WIDTH = 32;
        static final int BALLOON_ICON_HEIGHT = 32;
        static final int BALLOON_TRAY_ICON_INDENT = 0;
        static final Color BALLOON_CAPTION_BACKGROUND_COLOR = new Color(200, 200, 255);
        static final Font BALLOON_CAPTION_FONT = new Font("Dialog", 1, 12);
        XTrayIconPeer xtiPeer;
        Panel mainPanel = new Panel();
        Panel captionPanel = new Panel();
        Label captionLabel = new Label("");
        Button closeButton = new Button("X");
        Panel textPanel = new Panel();
        IconCanvas iconCanvas = new IconCanvas(32, 32);
        Label[] lineLabels = new Label[4];
        ActionPerformer ap = new ActionPerformer();
        Image iconImage;
        Image errorImage;
        Image warnImage;
        Image infoImage;
        boolean gtkImagesLoaded;
        Displayer displayer = new Displayer();

        Balloon(XTrayIconPeer xtiPeer, Frame parent) {
            super(parent, new Color(90, 80, 190));
            this.xtiPeer = xtiPeer;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (Balloon.this.textPanel != null) {
                        Balloon.this.textPanel.removeAll();
                        Balloon.this.textPanel.setSize(0, 0);
                        Balloon.this.iconCanvas.setSize(0, 0);
                        XToolkit.awtLock();
                        try {
                            Balloon.this.displayer.isDisplayed = false;
                            XToolkit.awtLockNotifyAll();
                        }
                        finally {
                            XToolkit.awtUnlock();
                        }
                    }
                }
            }, 10000);
            this.add(this.mainPanel);
            this.captionLabel.setFont(BALLOON_CAPTION_FONT);
            this.captionLabel.addMouseListener(this.ap);
            this.captionPanel.setLayout(new BorderLayout());
            this.captionPanel.add((Component)this.captionLabel, "West");
            this.captionPanel.add((Component)this.closeButton, "East");
            this.captionPanel.setBackground(BALLOON_CAPTION_BACKGROUND_COLOR);
            this.captionPanel.addMouseListener(this.ap);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Balloon.this.hide();
                }
            });
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBackground(Color.white);
            this.mainPanel.add((Component)this.captionPanel, "North");
            this.mainPanel.add((Component)this.iconCanvas, "West");
            this.mainPanel.add((Component)this.textPanel, "Center");
            this.iconCanvas.addMouseListener(this.ap);
            for (int i = 0; i < 4; ++i) {
                this.lineLabels[i] = new Label();
                this.lineLabels[i].addMouseListener(this.ap);
                this.lineLabels[i].setBackground(Color.white);
            }
            this.displayer.start();
        }

        void display(String caption, String text, String messageType) {
            if (!this.gtkImagesLoaded) {
                this.loadGtkImages();
            }
            this.displayer.display(caption, text, messageType);
        }

        private void _display(String caption, String text, String messageType) {
            this.captionLabel.setText(caption);
            BreakIterator iter = BreakIterator.getWordInstance();
            if (text != null) {
                int end;
                iter.setText(text);
                int start = iter.first();
                int nLines = 0;
                do {
                    if ((end = iter.next()) == -1 || text.substring(start, end).length() >= 50) {
                        this.lineLabels[nLines].setText(text.substring(start, end == -1 ? iter.last() : end));
                        this.textPanel.add(this.lineLabels[nLines++]);
                        start = end;
                    }
                    if (nLines != 4) continue;
                    if (end == -1) break;
                    this.lineLabels[nLines - 1].setText(new String(this.lineLabels[nLines - 1].getText() + " ..."));
                    break;
                } while (end != -1);
                this.textPanel.setLayout(new GridLayout(nLines, 1));
            }
            this.iconImage = "ERROR".equals(messageType) ? this.errorImage : ("WARNING".equals(messageType) ? this.warnImage : ("INFO".equals(messageType) ? this.infoImage : null));
            if (this.iconImage != null) {
                Dimension tpSize = this.textPanel.getSize();
                this.iconCanvas.setSize(32, 32 > tpSize.height ? 32 : tpSize.height);
            }
            SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                public void run() {
                    if (Balloon.this.xtiPeer.isDisposed()) {
                        return;
                    }
                    Point parLoc = Balloon.this.getParent().getLocationOnScreen();
                    Dimension parSize = Balloon.this.getParent().getSize();
                    Balloon.this.show(new Point(parLoc.x + parSize.width / 2, parLoc.y + parSize.height / 2), 0);
                    if (Balloon.this.iconImage != null) {
                        Balloon.this.iconCanvas.updateImage(Balloon.this.iconImage);
                    }
                }
            });
        }

        public void dispose() {
            this.displayer.interrupt();
            super.dispose();
        }

        void loadGtkImages() {
            if (!this.gtkImagesLoaded) {
                this.errorImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-error.6.rtl");
                this.warnImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-warning.6.rtl");
                this.infoImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-info.6.rtl");
                this.gtkImagesLoaded = true;
            }
        }

        class Message {
            String caption;
            String text;
            String messageType;

            Message(String caption, String text, String messageType) {
                this.caption = caption;
                this.text = text;
                this.messageType = messageType;
            }
        }

        class Displayer
        extends Thread {
            final int MAX_CONCURRENT_MSGS = 10;
            ArrayBlockingQueue<Message> messageQueue = new ArrayBlockingQueue(10);
            boolean isDisplayed;

            Displayer() {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Message msg = null;
                    try {
                        msg = this.messageQueue.take();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    XToolkit.awtLock();
                    try {
                        while (this.isDisplayed) {
                            try {
                                XToolkit.awtLockWait();
                            }
                            catch (InterruptedException e) {
                                XToolkit.awtUnlock();
                                return;
                            }
                        }
                        this.isDisplayed = true;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    Balloon.this._display(msg.caption, msg.text, msg.messageType);
                }
            }

            void display(String caption, String text, String messageType) {
                this.messageQueue.offer(new Message(caption, text, messageType));
            }
        }

        class ActionPerformer
        extends MouseAdapter {
            ActionPerformer() {
            }

            public void mouseClicked(MouseEvent e) {
                Balloon.this.hide();
                if (e.getButton() == 1) {
                    ActionEvent aev = new ActionEvent(Balloon.this.xtiPeer.target, 1001, Balloon.this.xtiPeer.target.getActionCommand(), e.getWhen(), e.getModifiers());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aev);
                }
            }
        }
    }

    static class Tooltip
    extends InfoWindow {
        XTrayIconPeer xtiPeer;
        Label textLabel = new Label("");
        Runnable starter = new Runnable(){

            public void run() {
                Tooltip.this.display();
            }
        };
        static final int TOOLTIP_SHOW_TIME = 10000;
        static final int TOOLTIP_START_DELAY_TIME = 1000;
        static final int TOOLTIP_MAX_LENGTH = 64;
        static final int TOOLTIP_MOUSE_CURSOR_INDENT = 5;
        static final Color TOOLTIP_BACKGROUND_COLOR = new Color(255, 255, 220);
        static final Font TOOLTIP_TEXT_FONT = XWindow.defaultFont;

        Tooltip(XTrayIconPeer xtiPeer, Frame parent) {
            super(parent, Color.black);
            this.xtiPeer = xtiPeer;
            XTrayIconPeer.suppressWarningString(this);
            this.setCloser(null, 10000);
            this.textLabel.setBackground(TOOLTIP_BACKGROUND_COLOR);
            this.textLabel.setFont(TOOLTIP_TEXT_FONT);
            this.add(this.textLabel);
        }

        void display() {
            String tip = this.xtiPeer.tooltipString;
            if (tip == null) {
                return;
            }
            if (tip.length() > 64) {
                this.textLabel.setText(tip.substring(0, 64));
            } else {
                this.textLabel.setText(tip);
            }
            SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                public void run() {
                    if (Tooltip.this.xtiPeer.isDisposed()) {
                        return;
                    }
                    Point pointer = (Point)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!Tooltip.this.isPointerOverTrayIcon(Tooltip.this.xtiPeer.getBounds())) {
                                return null;
                            }
                            return MouseInfo.getPointerInfo().getLocation();
                        }
                    });
                    if (pointer == null) {
                        return;
                    }
                    Tooltip.this.show(new Point(pointer.x, pointer.y), 5);
                }
            });
        }

        void enter() {
            XToolkit.schedule(this.starter, 1000L);
        }

        void exit() {
            XToolkit.remove(this.starter);
            if (this.isVisible()) {
                this.hide();
            }
        }

        boolean isPointerOverTrayIcon(Rectangle trayRect) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            return p.x >= trayRect.x && p.x <= trayRect.x + trayRect.width && p.y >= trayRect.y && p.y <= trayRect.y + trayRect.height;
        }
    }

    static class IconCanvas
    extends Canvas {
        volatile Image image;
        IconObserver observer;
        int width;
        int height;
        int curW;
        int curH;

        IconCanvas(int width, int height) {
            this.width = this.curW = width;
            this.height = this.curH = height;
        }

        public void updateImage(Image image) {
            this.image = image;
            if (this.observer == null) {
                this.observer = new IconObserver();
            }
            this.repaintImage(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void repaintImage(boolean doClear) {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    if (this.isVisible()) {
                        if (doClear) {
                            this.update(g);
                        } else {
                            this.paint(g);
                        }
                    }
                }
                finally {
                    g.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            BufferedImage bufImage;
            Graphics2D gr;
            if (g != null && this.curW > 0 && this.curH > 0 && (gr = (bufImage = new BufferedImage(this.curW, this.curH, 2)).createGraphics()) != null) {
                try {
                    gr.setColor(this.getBackground());
                    gr.fillRect(0, 0, this.curW, this.curH);
                    gr.drawImage(this.image, 0, 0, this.curW, this.curH, this.observer);
                    gr.dispose();
                    g.drawImage(bufImage, 0, 0, this.curW, this.curH, null);
                }
                finally {
                    gr.dispose();
                }
            }
        }

        class IconObserver
        implements ImageObserver {
            IconObserver() {
            }

            public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
                if (image != IconCanvas.this.image || !IconCanvas.this.isVisible()) {
                    return false;
                }
                if ((flags & 0x33) != 0) {
                    SunToolkit.executeOnEventHandlerThread(IconCanvas.this, new Runnable(){

                        public void run() {
                            IconCanvas.this.repaintImage(false);
                        }
                    });
                }
                return (flags & 0x20) == 0;
            }
        }
    }

    static class TrayIconCanvas
    extends IconCanvas {
        TrayIcon target;
        boolean autosize;

        TrayIconCanvas(TrayIcon target, int width, int height) {
            super(width, height);
            this.target = target;
        }

        protected void repaintImage(boolean doClear) {
            boolean old_autosize = this.autosize;
            this.autosize = this.target.isImageAutoSize();
            this.curW = this.autosize ? this.width : this.image.getWidth(this.observer);
            this.curH = this.autosize ? this.height : this.image.getHeight(this.observer);
            super.repaintImage(doClear || old_autosize != this.autosize);
        }
    }

    private static class XTrayIconEmbeddedFrame
    extends XEmbeddedFrame {
        public XTrayIconEmbeddedFrame() {
            super(XToolkit.getDefaultRootWindow(), true, true);
        }

        public boolean isUndecorated() {
            return true;
        }

        public boolean isResizable() {
            return false;
        }

        public void dispose() {
        }

        public void realDispose() {
            super.dispose();
        }
    }

    static class TrayIconEventProxy
    implements MouseListener,
    MouseMotionListener {
        XTrayIconPeer xtiPeer;

        TrayIconEventProxy(XTrayIconPeer xtiPeer) {
            this.xtiPeer = xtiPeer;
        }

        public void handleEvent(MouseEvent e) {
            if (e.getID() == 506) {
                return;
            }
            if (this.xtiPeer.isDisposed()) {
                return;
            }
            Point coord = XBaseWindow.toOtherWindow(this.xtiPeer.getWindow(), XToolkit.getDefaultRootWindow(), e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                this.xtiPeer.showPopupMenu(coord.x, coord.y);
            }
            e.translatePoint(coord.x - e.getX(), coord.y - e.getY());
            e.setSource(this.xtiPeer.target);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getClickCount() > 1 || this.xtiPeer.balloon.isVisible()) && e.getButton() == 1) {
                ActionEvent aev = new ActionEvent(this.xtiPeer.target, 1001, this.xtiPeer.target.getActionCommand(), e.getWhen(), e.getModifiers());
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aev);
            }
            if (this.xtiPeer.balloon.isVisible()) {
                this.xtiPeer.balloon.hide();
            }
            this.handleEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.xtiPeer.tooltip.enter();
            this.handleEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.xtiPeer.tooltip.exit();
            this.handleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e);
        }
    }
}

