/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.text.JTextComponent;
import sun.swing.plaf.synth.SynthUI;

class SynthTextAreaUI
extends BasicTextAreaUI
implements SynthUI {
    private SynthStyle style;

    SynthTextAreaUI() {
    }

    public static ComponentUI createUI(JComponent ta) {
        return new SynthTextAreaUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.getComponent());
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.getComponent(), 1);
        this.getComponent().putClientProperty("caretAspectRatio", null);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    private void updateStyle(JTextComponent comp) {
        SynthContext context = this.getContext(comp, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            SynthTextFieldUI.updateStyle(comp, context, this.getPropertyPrefix());
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTextAreaBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        super.paint(g, this.getComponent());
    }

    protected void paintBackground(Graphics g) {
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTextAreaBorder(context, g, x, y, w, h);
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTextComponent)evt.getSource());
        }
        super.propertyChange(evt);
    }
}

