/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.UnmodifiableSetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeSetUtilities {
    private AttributeSetUtilities() {
    }

    public static AttributeSet unmodifiableView(AttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableAttributeSet(attributeSet);
    }

    public static DocAttributeSet unmodifiableView(DocAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableDocAttributeSet(attributeSet);
    }

    public static PrintRequestAttributeSet unmodifiableView(PrintRequestAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintRequestAttributeSet(attributeSet);
    }

    public static PrintJobAttributeSet unmodifiableView(PrintJobAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintJobAttributeSet(attributeSet);
    }

    public static PrintServiceAttributeSet unmodifiableView(PrintServiceAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new UnmodifiablePrintServiceAttributeSet(attributeSet);
    }

    public static AttributeSet synchronizedView(AttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedAttributeSet(attributeSet);
    }

    public static DocAttributeSet synchronizedView(DocAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedDocAttributeSet(attributeSet);
    }

    public static PrintRequestAttributeSet synchronizedView(PrintRequestAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintRequestAttributeSet(attributeSet);
    }

    public static PrintJobAttributeSet synchronizedView(PrintJobAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintJobAttributeSet(attributeSet);
    }

    public static PrintServiceAttributeSet synchronizedView(PrintServiceAttributeSet attributeSet) {
        if (attributeSet == null) {
            throw new NullPointerException();
        }
        return new SynchronizedPrintServiceAttributeSet(attributeSet);
    }

    public static Class<?> verifyAttributeCategory(Object object, Class<?> interfaceName) {
        Class result = (Class)object;
        if (interfaceName.isAssignableFrom(result)) {
            return result;
        }
        throw new ClassCastException();
    }

    public static Attribute verifyAttributeValue(Object object, Class<?> interfaceName) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (interfaceName.isInstance(object)) {
            return (Attribute)object;
        }
        throw new ClassCastException();
    }

    public static void verifyCategoryForValue(Class<?> category, Attribute attribute) {
        if (!category.equals(attribute.getCategory())) {
            throw new IllegalArgumentException();
        }
    }

    private static class SynchronizedPrintServiceAttributeSet
    extends SynchronizedAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public SynchronizedPrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintJobAttributeSet
    extends SynchronizedAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public SynchronizedPrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintRequestAttributeSet
    extends SynchronizedAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public SynchronizedPrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedDocAttributeSet
    extends SynchronizedAttributeSet
    implements DocAttributeSet,
    Serializable {
        public SynchronizedDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public SynchronizedAttributeSet(AttributeSet attributeSet) {
            this.attrset = attributeSet;
        }

        @Override
        public synchronized Attribute get(Class<?> category) {
            return this.attrset.get(category);
        }

        @Override
        public synchronized boolean add(Attribute attribute) {
            return this.attrset.add(attribute);
        }

        @Override
        public synchronized boolean remove(Class<?> category) {
            return this.attrset.remove(category);
        }

        @Override
        public synchronized boolean remove(Attribute attribute) {
            return this.attrset.remove(attribute);
        }

        @Override
        public synchronized boolean containsKey(Class<?> category) {
            return this.attrset.containsKey(category);
        }

        @Override
        public synchronized boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        @Override
        public synchronized boolean addAll(AttributeSet attributes) {
            return this.attrset.addAll(attributes);
        }

        @Override
        public synchronized int size() {
            return this.attrset.size();
        }

        @Override
        public synchronized Attribute[] toArray() {
            return this.attrset.toArray();
        }

        @Override
        public synchronized void clear() {
            this.attrset.clear();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        @Override
        public synchronized boolean equals(Object o) {
            return ((Object)this.attrset).equals(o);
        }

        @Override
        public synchronized int hashCode() {
            return ((Object)this.attrset).hashCode();
        }
    }

    private static class UnmodifiablePrintServiceAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public UnmodifiablePrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintJobAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public UnmodifiablePrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintRequestAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public UnmodifiablePrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiableDocAttributeSet
    extends UnmodifiableAttributeSet
    implements DocAttributeSet,
    Serializable {
        public UnmodifiableDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public UnmodifiableAttributeSet(AttributeSet attributeSet) {
            this.attrset = attributeSet;
        }

        @Override
        public Attribute get(Class<?> key) {
            return this.attrset.get(key);
        }

        @Override
        public boolean add(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        @Override
        public synchronized boolean remove(Class<?> category) {
            throw new UnmodifiableSetException();
        }

        @Override
        public boolean remove(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        @Override
        public boolean containsKey(Class<?> category) {
            return this.attrset.containsKey(category);
        }

        @Override
        public boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        @Override
        public boolean addAll(AttributeSet attributes) {
            throw new UnmodifiableSetException();
        }

        @Override
        public int size() {
            return this.attrset.size();
        }

        @Override
        public Attribute[] toArray() {
            return this.attrset.toArray();
        }

        @Override
        public void clear() {
            throw new UnmodifiableSetException();
        }

        @Override
        public boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.attrset).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.attrset).hashCode();
        }
    }
}

