/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private static final long oldSerialVersionUID = 6001782699077323605L;
    private static final long newSerialVersionUID = 2605900539589789736L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("mySelectObjNameList", Vector.class), new ObjectStreamField("myDeselectObjNameList", Vector.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("selectedNames", List.class), new ObjectStreamField("deselectedNames", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private List<ObjectName> selectedNames = new Vector<ObjectName>();
    private List<ObjectName> deselectedNames = null;

    public MBeanServerNotificationFilter() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "MBeanServerNotificationFilter");
        this.enableType("JMX.mbean.registered");
        this.enableType("JMX.mbean.unregistered");
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "MBeanServerNotificationFilter");
    }

    public synchronized void disableAllObjectNames() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "disableAllObjectNames");
        this.selectedNames = new Vector<ObjectName>();
        this.deselectedNames = null;
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "disableAllObjectNames");
    }

    public synchronized void disableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "disableObjectName", objectName);
        if (this.selectedNames != null && this.selectedNames.size() != 0) {
            this.selectedNames.remove(objectName);
        }
        if (this.deselectedNames != null && !this.deselectedNames.contains(objectName)) {
            this.deselectedNames.add(objectName);
        }
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "disableObjectName");
    }

    public synchronized void enableAllObjectNames() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "enableAllObjectNames");
        this.selectedNames = null;
        this.deselectedNames = new Vector<ObjectName>();
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "enableAllObjectNames");
    }

    public synchronized void enableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "enableObjectName", objectName);
        if (this.deselectedNames != null && this.deselectedNames.size() != 0) {
            this.deselectedNames.remove(objectName);
        }
        if (this.selectedNames != null && !this.selectedNames.contains(objectName)) {
            this.selectedNames.add(objectName);
        }
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "enableObjectName");
    }

    public synchronized Vector<ObjectName> getEnabledObjectNames() {
        if (this.selectedNames != null) {
            return new Vector<ObjectName>(this.selectedNames);
        }
        return null;
    }

    public synchronized Vector<ObjectName> getDisabledObjectNames() {
        if (this.deselectedNames != null) {
            return new Vector<ObjectName>(this.deselectedNames);
        }
        return null;
    }

    @Override
    public synchronized boolean isNotificationEnabled(Notification notif) throws IllegalArgumentException {
        if (notif == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", notif);
        String ntfType = notif.getType();
        Vector<String> enabledTypes = this.getEnabledTypes();
        if (!enabledTypes.contains(ntfType)) {
            JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "Type not selected, exiting");
            return false;
        }
        MBeanServerNotification mbsNtf = (MBeanServerNotification)notif;
        ObjectName objName = mbsNtf.getMBeanName();
        boolean isSelectedFlg = false;
        if (this.selectedNames != null) {
            if (this.selectedNames.size() == 0) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "No ObjectNames selected, exiting");
                return false;
            }
            isSelectedFlg = this.selectedNames.contains(objName);
            if (!isSelectedFlg) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName not in selected list, exiting");
                return false;
            }
        }
        if (!isSelectedFlg) {
            if (this.deselectedNames == null) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName not selected, and all names deselected, exiting");
                return false;
            }
            if (this.deselectedNames.contains(objName)) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName explicitly not selected, exiting");
                return false;
            }
        }
        JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName selected, exiting");
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.selectedNames = (List)Util.cast(fields.get("mySelectObjNameList", null));
            if (fields.defaulted("mySelectObjNameList")) {
                throw new NullPointerException("mySelectObjNameList");
            }
            this.deselectedNames = (List)Util.cast(fields.get("myDeselectObjNameList", null));
            if (fields.defaulted("myDeselectObjNameList")) {
                throw new NullPointerException("myDeselectObjNameList");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("mySelectObjNameList", (Vector)this.selectedNames);
            fields.put("myDeselectObjNameList", (Vector)this.deselectedNames);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 6001782699077323605L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 2605900539589789736L;
        }
    }
}

