/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class MotifToggleButtonUI
extends BasicToggleButtonUI {
    private static final MotifToggleButtonUI motifToggleButtonUI = new MotifToggleButtonUI();
    protected Color selectColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent b) {
        return motifToggleButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(b, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Color oldColor = g.getColor();
            Dimension size = b.getSize();
            Insets insets = b.getInsets();
            Insets margin = b.getMargin();
            if (b.getBackground() instanceof UIResource) {
                g.setColor(this.getSelectColor());
            }
            g.fillRect(insets.left - margin.left, insets.top - margin.top, size.width - (insets.left - margin.left) - (insets.right - margin.right), size.height - (insets.top - margin.top) - (insets.bottom - margin.bottom));
            g.setColor(oldColor);
        }
    }

    public Insets getInsets(JComponent c) {
        Border border = c.getBorder();
        Insets i = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        return i;
    }
}

