/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack elementStack = null;

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public ElementIterator(Element root) {
        this.root = root;
    }

    public synchronized Object clone() {
        try {
            ElementIterator it = new ElementIterator(this.root);
            if (this.elementStack != null) {
                it.elementStack = new Stack();
                for (int i = 0; i < this.elementStack.size(); ++i) {
                    StackItem item = (StackItem)this.elementStack.elementAt(i);
                    StackItem clonee = (StackItem)item.clone();
                    it.elementStack.push(clonee);
                }
            }
            return it;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Element first() {
        if (this.root == null) {
            return null;
        }
        this.elementStack = new Stack();
        if (this.root.getElementCount() != 0) {
            this.elementStack.push(new StackItem(this.root));
        }
        return this.root;
    }

    public int depth() {
        if (this.elementStack == null) {
            return 0;
        }
        return this.elementStack.size();
    }

    public Element current() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (!this.elementStack.empty()) {
            StackItem item = (StackItem)this.elementStack.peek();
            Element elem = item.getElement();
            int index = item.getIndex();
            if (index == -1) {
                return elem;
            }
            return elem.getElement(index);
        }
        return null;
    }

    public Element next() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (this.elementStack.isEmpty()) {
            return null;
        }
        StackItem item = (StackItem)this.elementStack.peek();
        Element elem = item.getElement();
        int index = item.getIndex();
        if (index + 1 < elem.getElementCount()) {
            Element child = elem.getElement(index + 1);
            if (child.isLeaf()) {
                item.incrementIndex();
            } else {
                this.elementStack.push(new StackItem(child));
            }
            return child;
        }
        this.elementStack.pop();
        if (!this.elementStack.isEmpty()) {
            StackItem top = (StackItem)this.elementStack.peek();
            top.incrementIndex();
            return this.next();
        }
        return null;
    }

    public Element previous() {
        int stackSize;
        if (this.elementStack == null || (stackSize = this.elementStack.size()) == 0) {
            return null;
        }
        StackItem item = (StackItem)this.elementStack.peek();
        Element elem = item.getElement();
        int index = item.getIndex();
        if (index > 0) {
            return this.getDeepestLeaf(elem.getElement(--index));
        }
        if (index == 0) {
            return elem;
        }
        if (index == -1) {
            if (stackSize == 1) {
                return null;
            }
            Object top = this.elementStack.pop();
            item = (StackItem)this.elementStack.peek();
            this.elementStack.push(top);
            elem = item.getElement();
            index = item.getIndex();
            return index == -1 ? elem : this.getDeepestLeaf(elem.getElement(index));
        }
        return null;
    }

    private Element getDeepestLeaf(Element parent) {
        if (parent.isLeaf()) {
            return parent;
        }
        int childCount = parent.getElementCount();
        if (childCount == 0) {
            return parent;
        }
        return this.getDeepestLeaf(parent.getElement(childCount - 1));
    }

    private void dumpTree() {
        Element elem;
        while ((elem = this.next()) != null) {
            System.out.println("elem: " + elem.getName());
            AttributeSet attr = elem.getAttributes();
            String s = "";
            Enumeration<?> names = attr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object key = names.nextElement();
                Object value = attr.getAttribute(key);
                if (value instanceof AttributeSet) {
                    s = s + key + "=**AttributeSet** ";
                    continue;
                }
                s = s + key + "=" + value + " ";
            }
            System.out.println("attributes: " + s);
        }
    }

    private class StackItem
    implements Cloneable {
        Element item;
        int childIndex;

        private StackItem(Element elem) {
            this.item = elem;
            this.childIndex = -1;
        }

        private void incrementIndex() {
            ++this.childIndex;
        }

        private Element getElement() {
            return this.item;
        }

        private int getIndex() {
            return this.childIndex;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

