/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import javax.sql.RowSetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;
    static final long serialVersionUID = 6893806403181801867L;

    private void checkColRange(int col) throws SQLException {
        if (col <= 0 || col > this.colCount) {
            throw new SQLException("Invalid column index :" + col);
        }
    }

    private void checkColType(int SQLType) throws SQLException {
        try {
            Class<Types> c = Types.class;
            Field[] publicFields = c.getFields();
            int fieldValue = 0;
            for (int i = 0; i < publicFields.length; ++i) {
                fieldValue = publicFields[i].getInt(c);
                if (fieldValue != SQLType) continue;
                return;
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        throw new SQLException("Invalid SQL type for column");
    }

    @Override
    public void setColumnCount(int columnCount) throws SQLException {
        if (columnCount <= 0) {
            throw new SQLException("Invalid column count. Cannot be less or equal to zero");
        }
        this.colCount = columnCount;
        if (this.colCount != Integer.MAX_VALUE) {
            this.colInfo = new ColInfo[this.colCount + 1];
            for (int i = 1; i <= this.colCount; ++i) {
                this.colInfo[i] = new ColInfo();
            }
        }
    }

    @Override
    public void setAutoIncrement(int columnIndex, boolean property) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].autoIncrement = property;
    }

    @Override
    public void setCaseSensitive(int columnIndex, boolean property) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].caseSensitive = property;
    }

    @Override
    public void setSearchable(int columnIndex, boolean property) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].searchable = property;
    }

    @Override
    public void setCurrency(int columnIndex, boolean property) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].currency = property;
    }

    @Override
    public void setNullable(int columnIndex, int property) throws SQLException {
        if (property < 0 || property > 2) {
            throw new SQLException("Invalid nullable constant set. Must be either columnNoNulls, columnNullable or columnNullableUnknown");
        }
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].nullable = property;
    }

    @Override
    public void setSigned(int columnIndex, boolean property) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].signed = property;
    }

    @Override
    public void setColumnDisplaySize(int columnIndex, int size) throws SQLException {
        if (size < 0) {
            throw new SQLException("Invalid column display size. Cannot be less than zero");
        }
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].columnDisplaySize = size;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].columnLabel = label != null ? new String(label) : new String("");
    }

    @Override
    public void setColumnName(int columnIndex, String columnName) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].columnName = columnName != null ? new String(columnName) : new String("");
    }

    @Override
    public void setSchemaName(int columnIndex, String schemaName) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].schemaName = schemaName != null ? new String(schemaName) : new String("");
    }

    @Override
    public void setPrecision(int columnIndex, int precision) throws SQLException {
        if (precision < 0) {
            throw new SQLException("Invalid precision value. Cannot be less than zero");
        }
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].colPrecision = precision;
    }

    @Override
    public void setScale(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            throw new SQLException("Invalid scale size. Cannot be less than zero");
        }
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].colScale = scale;
    }

    @Override
    public void setTableName(int columnIndex, String tableName) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].tableName = tableName != null ? new String(tableName) : new String("");
    }

    @Override
    public void setCatalogName(int columnIndex, String catalogName) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].catName = catalogName != null ? new String(catalogName) : new String("");
    }

    @Override
    public void setColumnType(int columnIndex, int SQLType) throws SQLException {
        this.checkColType(SQLType);
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].colType = SQLType;
    }

    @Override
    public void setColumnTypeName(int columnIndex, String typeName) throws SQLException {
        this.checkColRange(columnIndex);
        this.colInfo[columnIndex].colTypeName = typeName != null ? new String(typeName) : new String("");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].caseSensitive;
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].searchable;
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].currency;
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].nullable;
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].signed;
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].columnDisplaySize;
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].columnLabel;
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].columnName;
    }

    @Override
    public String getSchemaName(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        String str = "";
        if (this.colInfo[columnIndex].schemaName != null) {
            str = this.colInfo[columnIndex].schemaName;
        }
        return str;
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].colPrecision;
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].colScale;
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].tableName;
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        String str = "";
        if (this.colInfo[columnIndex].catName != null) {
            str = this.colInfo[columnIndex].catName;
        }
        return str;
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].colType;
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].colTypeName;
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].readOnly;
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        this.checkColRange(columnIndex);
        return this.colInfo[columnIndex].writable;
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        return true;
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        String className = new String().getClass().getName();
        int sqlType = this.getColumnType(columnIndex);
        switch (sqlType) {
            case 2: 
            case 3: {
                className = new BigDecimal(0).getClass().getName();
                break;
            }
            case -7: {
                className = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                className = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                className = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                className = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                className = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                className = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                className = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] b = new byte[]{};
                className = b.getClass().getName();
                break;
            }
            case 91: {
                className = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                className = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                className = new Timestamp(123456L).getClass().getName();
                break;
            }
            case 2004: {
                byte[] blob = new byte[]{};
                className = blob.getClass().getName();
                break;
            }
            case 2005: {
                char[] c = new char[]{};
                className = c.getClass().getName();
            }
        }
        return className;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        return false;
    }

    private class ColInfo
    implements Serializable {
        public boolean autoIncrement;
        public boolean caseSensitive;
        public boolean currency;
        public int nullable;
        public boolean signed;
        public boolean searchable;
        public int columnDisplaySize;
        public String columnLabel;
        public String columnName;
        public String schemaName;
        public int colPrecision;
        public int colScale;
        public String tableName = "";
        public String catName;
        public int colType;
        public String colTypeName;
        public boolean readOnly = false;
        public boolean writable = true;

        private ColInfo() {
        }
    }
}

