/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.peer.TextAreaPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class TextArea
extends TextComponent {
    int rows;
    int columns;
    private static final String base = "text";
    private static int nameCounter = 0;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility;
    private static Set forwardTraversalKeys;
    private static Set backwardTraversalKeys;
    private static final long serialVersionUID = 3692302836626095722L;
    private int textAreaSerializedDataVersion = 2;

    private static native void initIDs();

    public TextArea() throws HeadlessException {
        this("", 0, 0, 0);
    }

    public TextArea(String text) throws HeadlessException {
        this(text, 0, 0, 0);
    }

    public TextArea(int rows, int columns) throws HeadlessException {
        this("", rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns) throws HeadlessException {
        this(text, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int scrollbars) throws HeadlessException {
        super(text);
        this.rows = rows >= 0 ? rows : 0;
        this.columns = columns >= 0 ? columns : 0;
        this.scrollbarVisibility = scrollbars >= 0 && scrollbars <= 3 ? scrollbars : 0;
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<TextArea> clazz = TextArea.class;
        synchronized (TextArea.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextArea(this);
            }
            super.addNotify();
        }
    }

    public void insert(String str, int pos) {
        this.insertText(str, pos);
    }

    @Deprecated
    public synchronized void insertText(String str, int pos) {
        TextAreaPeer peer = (TextAreaPeer)this.peer;
        if (peer != null) {
            peer.insertText(str, pos);
        } else {
            this.text = this.text.substring(0, pos) + str + this.text.substring(pos);
        }
    }

    public void append(String str) {
        this.appendText(str);
    }

    @Deprecated
    public synchronized void appendText(String str) {
        if (this.peer != null) {
            this.insertText(str, this.getText().length());
        } else {
            this.text = this.text + str;
        }
    }

    public void replaceRange(String str, int start, int end) {
        this.replaceText(str, start, end);
    }

    @Deprecated
    public synchronized void replaceText(String str, int start, int end) {
        TextAreaPeer peer = (TextAreaPeer)this.peer;
        if (peer != null) {
            peer.replaceText(str, start, end);
        } else {
            this.text = this.text.substring(0, start) + str + this.text.substring(end);
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        int oldVal = this.rows;
        if (rows < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (rows != oldVal) {
            this.rows = rows;
            this.invalidate();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public Dimension getPreferredSize(int rows, int columns) {
        return this.preferredSize(rows, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize(int rows, int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer peer = (TextAreaPeer)this.peer;
            return peer != null ? peer.preferredSize(rows, columns) : super.preferredSize();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 && this.columns > 0 ? this.preferredSize(this.rows, this.columns) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int rows, int columns) {
        return this.minimumSize(rows, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize(int rows, int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer peer = (TextAreaPeer)this.peer;
            return peer != null ? peer.minimumSize(rows, columns) : super.minimumSize();
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 && this.columns > 0 ? this.minimumSize(this.rows, this.columns) : super.minimumSize();
        }
    }

    protected String paramString() {
        String sbVisStr;
        switch (this.scrollbarVisibility) {
            case 0: {
                sbVisStr = "both";
                break;
            }
            case 1: {
                sbVisStr = "vertical-only";
                break;
            }
            case 2: {
                sbVisStr = "horizontal-only";
                break;
            }
            case 3: {
                sbVisStr = "none";
                break;
            }
            default: {
                sbVisStr = "invalid display policy";
            }
        }
        return super.paramString() + ",rows=" + this.rows + ",columns=" + this.columns + ",scrollbarVisibility=" + sbVisStr;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        s.defaultReadObject();
        if (this.columns < 0) {
            this.columns = 0;
        }
        if (this.rows < 0) {
            this.rows = 0;
        }
        if (this.scrollbarVisibility < 0 || this.scrollbarVisibility > 3) {
            this.scrollbarVisibility = 0;
        }
        if (this.textAreaSerializedDataVersion < 2) {
            this.setFocusTraversalKeys(0, forwardTraversalKeys);
            this.setFocusTraversalKeys(1, backwardTraversalKeys);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextArea();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            TextArea.initIDs();
        }
        forwardTraversalKeys = KeyboardFocusManager.initFocusTraversalKeysSet("ctrl TAB", new HashSet());
        backwardTraversalKeys = KeyboardFocusManager.initFocusTraversalKeysSet("ctrl shift TAB", new HashSet());
    }

    protected class AccessibleAWTTextArea
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 3472827823632144419L;

        protected AccessibleAWTTextArea() {
            super(TextArea.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.MULTI_LINE);
            return states;
        }
    }
}

