/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.plaf.synth.SynthUI;

class SynthTableUI
extends BasicTableUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private boolean useTableColors;
    private boolean useUIBorder;
    private TableCellRenderer dateRenderer;
    private TableCellRenderer numberRenderer;
    private TableCellRenderer doubleRender;
    private TableCellRenderer floatRenderer;
    private TableCellRenderer iconRenderer;
    private TableCellRenderer imageIconRenderer;
    private TableCellRenderer booleanRenderer;
    private TableCellRenderer objectRenderer;

    SynthTableUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthTableUI();
    }

    protected void installDefaults() {
        this.dateRenderer = this.installRendererIfPossible(Date.class, null);
        this.numberRenderer = this.installRendererIfPossible(Number.class, null);
        this.doubleRender = this.installRendererIfPossible(Double.class, null);
        this.floatRenderer = this.installRendererIfPossible(Float.class, null);
        this.iconRenderer = this.installRendererIfPossible(Icon.class, null);
        this.imageIconRenderer = this.installRendererIfPossible(ImageIcon.class, null);
        this.booleanRenderer = this.installRendererIfPossible(Boolean.class, new SynthBooleanTableCellRenderer());
        this.objectRenderer = this.installRendererIfPossible(Object.class, new SynthTableCellRenderer());
        this.updateStyle(this.table);
    }

    private TableCellRenderer installRendererIfPossible(Class objectClass, TableCellRenderer renderer) {
        TableCellRenderer currentRenderer = this.table.getDefaultRenderer(objectClass);
        if (currentRenderer instanceof UIResource) {
            this.table.setDefaultRenderer(objectClass, renderer);
        }
        return currentRenderer;
    }

    private void updateStyle(JTable c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Color sfg;
            context.setComponentState(513);
            Color sbg = this.table.getSelectionBackground();
            if (sbg == null || sbg instanceof UIResource) {
                this.table.setSelectionBackground(this.style.getColor(context, ColorType.TEXT_BACKGROUND));
            }
            if ((sfg = this.table.getSelectionForeground()) == null || sfg instanceof UIResource) {
                this.table.setSelectionForeground(this.style.getColor(context, ColorType.TEXT_FOREGROUND));
            }
            context.setComponentState(1);
            Color gridColor = this.table.getGridColor();
            if (gridColor == null || gridColor instanceof UIResource) {
                gridColor = (Color)this.style.get(context, "Table.gridColor");
                if (gridColor == null) {
                    gridColor = this.style.getColor(context, ColorType.FOREGROUND);
                }
                this.table.setGridColor(gridColor);
            }
            this.useTableColors = this.style.getBoolean(context, "Table.rendererUseTableColors", true);
            this.useUIBorder = this.style.getBoolean(context, "Table.rendererUseUIBorder", true);
            Object rowHeight = this.style.get(context, "Table.rowHeight");
            if (rowHeight != null) {
                LookAndFeel.installProperty(this.table, "rowHeight", rowHeight);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        this.table.setDefaultRenderer(Date.class, this.dateRenderer);
        this.table.setDefaultRenderer(Number.class, this.numberRenderer);
        this.table.setDefaultRenderer(Double.class, this.doubleRender);
        this.table.setDefaultRenderer(Float.class, this.floatRenderer);
        this.table.setDefaultRenderer(Icon.class, this.iconRenderer);
        this.table.setDefaultRenderer(ImageIcon.class, this.imageIconRenderer);
        this.table.setDefaultRenderer(Boolean.class, this.booleanRenderer);
        this.table.setDefaultRenderer(Object.class, this.objectRenderer);
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
        SynthContext context = this.getContext(this.table, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTableBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTableBorder(context, g, x, y, w, h);
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(context, g);
            return;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(context, g, rMin, rMax, cMin, cMax);
        this.paintCells(context, g, rMin, rMax, cMin, cMax);
        this.paintDropLines(context, g);
    }

    private void paintDropLines(SynthContext context, Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = (Color)this.style.get(context, "Table.dropLineColor");
        Color shortColor = (Color)this.style.get(context, "Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    private void paintGrid(SynthContext context, Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            SynthGraphicsUtils synthG = context.getStyle().getGraphicsUtils(context);
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    synthG.drawLine(context, "Table.grid", g, damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    synthG.drawLine(context, "Table.grid", g, (x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    synthG.drawLine(context, "Table.grid", g, (x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCells(SynthContext context, Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(context, g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(context, g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(context, g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(context, g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(SynthContext context, Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(context.getStyle().getColor(context, ColorType.BACKGROUND));
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        SynthGraphicsUtils synthG = context.getStyle().getGraphicsUtils(context);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            synthG.drawLine(context, "Table.grid", g, x1 - 1, y1, x1 - 1, y2);
            synthG.drawLine(context, "Table.grid", g, x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(context, g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            synthG.drawLine(context, "Table.grid", g, x1, y2, x2, y2);
        }
    }

    private void paintCell(SynthContext context, Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (SynthLookAndFeel.shouldUpdateStyle(event)) {
            this.updateStyle((JTable)event.getSource());
        }
    }

    private class SynthTableCellRenderer
    extends DefaultTableCellRenderer {
        private Object numberFormat;
        private Object dateFormat;
        private boolean opaque;

        private SynthTableCellRenderer() {
        }

        public void setOpaque(boolean isOpaque) {
            this.opaque = isOpaque;
        }

        public boolean isOpaque() {
            return this.opaque;
        }

        public String getName() {
            String name = super.getName();
            if (name == null) {
                return "Table.cellRenderer";
            }
            return name;
        }

        public void setBorder(Border b) {
            if (SynthTableUI.this.useUIBorder || b instanceof SynthBorder) {
                super.setBorder(b);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!SynthTableUI.this.useTableColors && (isSelected || hasFocus)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, hasFocus, table.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(null);
            Class<?> columnClass = table.getColumnClass(column);
            this.configureValue(value, columnClass);
            return this;
        }

        private void configureValue(Object value, Class columnClass) {
            if (columnClass == Object.class || columnClass == null) {
                this.setHorizontalAlignment(10);
            } else if (columnClass == Float.class || columnClass == Double.class) {
                if (this.numberFormat == null) {
                    this.numberFormat = NumberFormat.getInstance();
                }
                this.setHorizontalAlignment(11);
                this.setText(value == null ? "" : ((NumberFormat)this.numberFormat).format(value));
            } else if (columnClass == Number.class) {
                this.setHorizontalAlignment(11);
            } else if (columnClass == Icon.class || columnClass == ImageIcon.class) {
                this.setHorizontalAlignment(0);
                this.setIcon((Icon)value);
                this.setText("");
            } else if (columnClass == Date.class) {
                if (this.dateFormat == null) {
                    this.dateFormat = DateFormat.getDateInstance();
                }
                this.setHorizontalAlignment(10);
                this.setText(value == null ? "" : ((Format)this.dateFormat).format(value));
            } else {
                this.configureValue(value, columnClass.getSuperclass());
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            SynthLookAndFeel.resetSelectedUI();
        }
    }

    private class SynthBooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private boolean isRowSelected;

        public SynthBooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public String getName() {
            String name = super.getName();
            if (name == null) {
                return "Table.cellRenderer";
            }
            return name;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.isRowSelected = isSelected;
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }

        public boolean isOpaque() {
            return this.isRowSelected ? true : super.isOpaque();
        }
    }
}

