/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ServerHandshaker
extends Handshaker {
    private byte doClientAuth;
    private X509Certificate[] certs;
    private PrivateKey privateKey;
    private KerberosKey[] kerberosKeys;
    private boolean needClientVerify = false;
    private PrivateKey tempPrivateKey;
    private PublicKey tempPublicKey;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private ProtocolVersion clientRequestedVersion;
    private SupportedEllipticCurvesExtension supportedCurves;

    ServerHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols, byte clientAuth) {
        super(socket, context, enabledProtocols, clientAuth != 0, false);
        this.doClientAuth = clientAuth;
    }

    ServerHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, byte clientAuth) {
        super(engine, context, enabledProtocols, clientAuth != 0, false);
        this.doClientAuth = clientAuth;
    }

    void setClientAuth(byte clientAuth) {
        this.doClientAuth = clientAuth;
    }

    void processMessage(byte type, int message_len) throws IOException {
        if (this.state > type && this.state != 16 && type != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + type);
        }
        switch (type) {
            case 1: {
                HandshakeMessage.ClientHello ch = new HandshakeMessage.ClientHello(this.input, message_len);
                this.clientHello(ch);
                break;
            }
            case 11: {
                if (this.doClientAuth == 0) {
                    this.fatalSE((byte)10, "client sent unsolicited cert chain");
                }
                this.clientCertificate(new HandshakeMessage.CertificateMsg(this.input));
                break;
            }
            case 16: {
                SecretKey preMasterSecret;
                switch (this.keyExchange) {
                    case K_RSA: 
                    case K_RSA_EXPORT: {
                        RSAClientKeyExchange pms = new RSAClientKeyExchange(this.protocolVersion, this.input, message_len, this.privateKey);
                        preMasterSecret = this.clientKeyExchange(pms);
                        break;
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        preMasterSecret = this.clientKeyExchange(new KerberosClientKeyExchange(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, this.kerberosKeys));
                        break;
                    }
                    case K_DHE_RSA: 
                    case K_DHE_DSS: 
                    case K_DH_ANON: {
                        preMasterSecret = this.clientKeyExchange(new DHClientKeyExchange(this.input));
                        break;
                    }
                    case K_ECDH_RSA: 
                    case K_ECDH_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDHE_ECDSA: 
                    case K_ECDH_ANON: {
                        preMasterSecret = this.clientKeyExchange(new ECDHClientKeyExchange(this.input));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("Unrecognized key exchange: " + (Object)((Object)this.keyExchange));
                    }
                }
                this.calculateKeys(preMasterSecret, this.clientRequestedVersion);
                break;
            }
            case 15: {
                this.clientCertificateVerify(new HandshakeMessage.CertificateVerify(this.input));
                break;
            }
            case 20: {
                this.clientFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + type);
            }
        }
        if (this.state < type && type != 15) {
            this.state = type;
        }
    }

    private void clientHello(HandshakeMessage.ClientHello mesg) throws IOException {
        HandshakeMessage.ServerKeyExchange m3;
        SSLSessionImpl previous;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        this.input.digestNow();
        HandshakeMessage.ServerHello m1 = new HandshakeMessage.ServerHello();
        this.clientRequestedVersion = mesg.protocolVersion;
        if (this.clientRequestedVersion.v < this.enabledProtocols.min.v) {
            this.fatalSE((byte)40, "Client requested protocol " + this.clientRequestedVersion + " not enabled or not supported");
        }
        ProtocolVersion selectedVersion = this.clientRequestedVersion.v <= this.enabledProtocols.max.v ? this.clientRequestedVersion : this.enabledProtocols.max;
        this.setVersion(selectedVersion);
        m1.protocolVersion = this.protocolVersion;
        this.clnt_random = mesg.clnt_random;
        m1.svr_random = this.svr_random = new RandomCookie(this.sslContext.getSecureRandom());
        this.session = null;
        if (mesg.sessionId.length() != 0 && (previous = ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).get(mesg.sessionId.getId())) != null) {
            CipherSuite suite;
            ProtocolVersion oldVersion;
            this.resumingSession = previous.isRejoinable();
            if (this.resumingSession && (oldVersion = previous.getProtocolVersion()) != this.protocolVersion) {
                this.resumingSession = false;
            }
            if (this.resumingSession && this.doClientAuth == 2) {
                try {
                    previous.getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException e) {
                    this.resumingSession = false;
                }
            }
            if (this.resumingSession) {
                suite = previous.getSuite();
                if (suite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || suite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    Principal localPrincipal;
                    block53: {
                        localPrincipal = previous.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Util.getSubject((int)4, (AccessControlContext)ServerHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block53;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
                        if (!principals.contains(localPrincipal)) {
                            this.resumingSession = false;
                            if (debug != null && Debug.isOn("session")) {
                                System.out.println("Subject identity is not the same");
                            }
                        } else if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        this.resumingSession = false;
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                    }
                }
            }
            if (this.resumingSession) {
                suite = previous.getSuite();
                if (!this.isEnabled(suite) || !mesg.getCipherSuites().contains(suite)) {
                    this.resumingSession = false;
                } else {
                    this.setCipherSuite(suite);
                }
            }
            if (this.resumingSession) {
                this.session = previous;
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.session);
                }
            }
        }
        if (this.session == null) {
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            this.supportedCurves = (SupportedEllipticCurvesExtension)mesg.extensions.get(ExtensionType.EXT_ELLIPTIC_CURVES);
            this.chooseCipherSuite(mesg);
            this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.sslContext.getSecureRandom(), this.getHostAddressSE(), this.getPortSE());
            this.session.setLocalPrivateKey(this.privateKey);
        }
        m1.cipherSuite = this.cipherSuite;
        m1.sessionId = this.session.getSessionId();
        m1.compression_method = this.session.getCompression();
        if (debug != null && Debug.isOn("handshake")) {
            m1.print(System.out);
            System.out.println("Cipher suite:  " + this.session.getSuite());
        }
        m1.write(this.output);
        if (this.resumingSession) {
            this.calculateConnectionKeys(this.session.getMasterSecret());
            this.sendChangeCipherAndFinish(false);
            return;
        }
        if (this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
                if (this.certs == null) {
                    throw new RuntimeException("no certificates");
                }
                HandshakeMessage.CertificateMsg m2 = new HandshakeMessage.CertificateMsg(this.certs);
                this.session.setLocalCertificates(this.certs);
                if (debug != null && Debug.isOn("handshake")) {
                    m2.print(System.out);
                }
                m2.write(this.output);
            } else if (this.certs != null) {
                throw new RuntimeException("anonymous keyexchange with certs");
            }
        }
        switch (this.keyExchange) {
            case K_RSA: 
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                m3 = null;
                break;
            }
            case K_RSA_EXPORT: {
                if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512) {
                    try {
                        m3 = new HandshakeMessage.RSA_ServerKeyExchange(this.tempPublicKey, this.privateKey, this.clnt_random, this.svr_random, this.sslContext.getSecureRandom());
                        this.privateKey = this.tempPrivateKey;
                    }
                    catch (GeneralSecurityException e) {
                        ServerHandshaker.throwSSLException("Error generating RSA server key exchange", e);
                        m3 = null;
                    }
                    break;
                }
                m3 = null;
                break;
            }
            case K_DHE_RSA: 
            case K_DHE_DSS: {
                try {
                    m3 = new HandshakeMessage.DH_ServerKeyExchange(this.dh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom());
                }
                catch (GeneralSecurityException e) {
                    ServerHandshaker.throwSSLException("Error generating DH server key exchange", e);
                    m3 = null;
                }
                break;
            }
            case K_DH_ANON: {
                m3 = new HandshakeMessage.DH_ServerKeyExchange(this.dh);
                break;
            }
            case K_ECDHE_RSA: 
            case K_ECDHE_ECDSA: 
            case K_ECDH_ANON: {
                try {
                    m3 = new HandshakeMessage.ECDH_ServerKeyExchange(this.ecdh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom());
                }
                catch (GeneralSecurityException e) {
                    ServerHandshaker.throwSSLException("Error generating ECDH server key exchange", e);
                    m3 = null;
                }
                break;
            }
            case K_ECDH_RSA: 
            case K_ECDH_ECDSA: {
                m3 = null;
                break;
            }
            default: {
                throw new RuntimeException("internal error: " + (Object)((Object)this.keyExchange));
            }
        }
        if (m3 != null) {
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)m3).print(System.out);
            }
            m3.write(this.output);
        }
        if (this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT && this.doClientAuth != 0 && this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
            X509Certificate[] caCerts = this.sslContext.getX509TrustManager().getAcceptedIssuers();
            HandshakeMessage.CertificateRequest m4 = new HandshakeMessage.CertificateRequest(caCerts, this.keyExchange);
            if (debug != null && Debug.isOn("handshake")) {
                m4.print(System.out);
            }
            m4.write(this.output);
        }
        HandshakeMessage.ServerHelloDone m5 = new HandshakeMessage.ServerHelloDone();
        if (debug != null && Debug.isOn("handshake")) {
            m5.print(System.out);
        }
        m5.write(this.output);
        this.output.flush();
    }

    private void chooseCipherSuite(HandshakeMessage.ClientHello mesg) throws IOException {
        for (CipherSuite suite : mesg.getCipherSuites().collection()) {
            if (!this.isEnabled(suite) || this.doClientAuth == 2 && (suite.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || suite.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) || !this.trySetCipherSuite(suite)) continue;
            return;
        }
        this.fatalSE((byte)40, "no cipher suites in common");
    }

    boolean trySetCipherSuite(CipherSuite suite) {
        if (this.resumingSession) {
            return true;
        }
        if (!suite.isAvailable()) {
            return false;
        }
        CipherSuite.KeyExchange keyExchange = suite.keyExchange;
        this.privateKey = null;
        this.certs = null;
        this.dh = null;
        this.tempPrivateKey = null;
        this.tempPublicKey = null;
        switch (keyExchange) {
            case K_RSA: 
            case K_RSA_EXPORT: 
            case K_DHE_RSA: 
            case K_ECDHE_RSA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                if (keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT) {
                    try {
                        if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512 && !this.setupEphemeralRSAKeys(suite.exportable)) {
                            return false;
                        }
                        break;
                    }
                    catch (RuntimeException e) {
                        return false;
                    }
                }
                if (keyExchange == CipherSuite.KeyExchange.K_DHE_RSA) {
                    this.setupEphemeralDHKeys(suite.exportable);
                    break;
                }
                if (keyExchange != CipherSuite.KeyExchange.K_ECDHE_RSA || this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_DHE_DSS: {
                if (!this.setupPrivateKeyAndChain("DSA")) {
                    return false;
                }
                this.setupEphemeralDHKeys(suite.exportable);
                break;
            }
            case K_ECDHE_ECDSA: {
                if (!this.setupPrivateKeyAndChain("EC_EC")) {
                    return false;
                }
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_ECDH_RSA: {
                if (!this.setupPrivateKeyAndChain("EC_RSA")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_ECDH_ECDSA: {
                if (!this.setupPrivateKeyAndChain("EC_EC")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                if (this.setupKerberosKeys()) break;
                return false;
            }
            case K_DH_ANON: {
                this.setupEphemeralDHKeys(suite.exportable);
                break;
            }
            case K_ECDH_ANON: {
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            default: {
                throw new RuntimeException("Unrecognized cipherSuite: " + suite);
            }
        }
        this.setCipherSuite(suite);
        return true;
    }

    private boolean setupEphemeralRSAKeys(boolean export) {
        KeyPair kp = this.sslContext.getEphemeralKeyManager().getRSAKeyPair(export, this.sslContext.getSecureRandom());
        if (kp == null) {
            return false;
        }
        this.tempPublicKey = kp.getPublic();
        this.tempPrivateKey = kp.getPrivate();
        return true;
    }

    private void setupEphemeralDHKeys(boolean export) {
        this.dh = new DHCrypt(export ? 512 : 768, this.sslContext.getSecureRandom());
    }

    private boolean setupEphemeralECDHKeys() {
        int index = -1;
        if (this.supportedCurves != null) {
            for (int curveId : this.supportedCurves.curveIds()) {
                if (!SupportedEllipticCurvesExtension.isSupported(curveId)) continue;
                index = curveId;
                break;
            }
            if (index < 0) {
                return false;
            }
        } else {
            index = SupportedEllipticCurvesExtension.DEFAULT.curveIds()[0];
        }
        String oid = SupportedEllipticCurvesExtension.getCurveOid(index);
        this.ecdh = new ECDHCrypt(oid, this.sslContext.getSecureRandom());
        return true;
    }

    private void setupStaticECDHKeys() {
        this.ecdh = new ECDHCrypt(this.privateKey, this.certs[0].getPublicKey());
    }

    private boolean setupPrivateKeyAndChain(String algorithm) {
        X509ExtendedKeyManager km = this.sslContext.getX509KeyManager();
        String alias = this.conn != null ? km.chooseServerAlias(algorithm, null, this.conn) : km.chooseEngineServerAlias(algorithm, null, this.engine);
        if (alias == null) {
            return false;
        }
        PrivateKey tempPrivateKey = km.getPrivateKey(alias);
        if (tempPrivateKey == null) {
            return false;
        }
        X509Certificate[] tempCerts = km.getCertificateChain(alias);
        if (tempCerts == null || tempCerts.length == 0) {
            return false;
        }
        String keyAlgorithm = algorithm.split("_")[0];
        PublicKey publicKey = tempCerts[0].getPublicKey();
        if (!tempPrivateKey.getAlgorithm().equals(keyAlgorithm) || !publicKey.getAlgorithm().equals(keyAlgorithm)) {
            return false;
        }
        if (keyAlgorithm.equals("EC")) {
            if (!(publicKey instanceof ECPublicKey)) {
                return false;
            }
            ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
            int index = SupportedEllipticCurvesExtension.getCurveIndex(params);
            if (!SupportedEllipticCurvesExtension.isSupported(index)) {
                return false;
            }
            if (this.supportedCurves != null && !this.supportedCurves.contains(index)) {
                return false;
            }
        }
        this.privateKey = tempPrivateKey;
        this.certs = tempCerts;
        return true;
    }

    private boolean setupKerberosKeys() {
        if (this.kerberosKeys != null) {
            return true;
        }
        try {
            final AccessControlContext acc = this.getAccSE();
            this.kerberosKeys = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosKey[]>(){

                @Override
                public KerberosKey[] run() throws Exception {
                    return Krb5Util.getKeys((int)4, null, (AccessControlContext)acc);
                }
            });
            if (this.kerberosKeys != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Using Kerberos key: " + this.kerberosKeys[0]);
                }
                String serverPrincipal = this.kerberosKeys[0].getPrincipal().getName();
                SecurityManager sm = System.getSecurityManager();
                try {
                    if (sm != null) {
                        sm.checkPermission(new ServicePermission(serverPrincipal, "accept"), acc);
                    }
                }
                catch (SecurityException se) {
                    this.kerberosKeys = null;
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("Permission to access Kerberos secret key denied");
                    }
                    return false;
                }
            }
            return this.kerberosKeys != null;
        }
        catch (PrivilegedActionException e) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Attempt to obtain Kerberos key failed: " + e.toString());
            }
            return false;
        }
    }

    private SecretKey clientKeyExchange(KerberosClientKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        this.session.setPeerPrincipal(mesg.getPeerPrincipal());
        this.session.setLocalPrincipal(mesg.getLocalPrincipal());
        byte[] b = mesg.getPreMasterSecret().getUnencrypted();
        return new SecretKeySpec(b, "TlsPremasterSecret");
    }

    private SecretKey clientKeyExchange(DHClientKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        return this.dh.getAgreedSecret(mesg.getClientPublicKey());
    }

    private SecretKey clientKeyExchange(ECDHClientKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        return this.ecdh.getAgreedSecret(mesg.getEncodedPoint());
    }

    private void clientCertificateVerify(HandshakeMessage.CertificateVerify mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        try {
            PublicKey publicKey = this.session.getPeerCertificates()[0].getPublicKey();
            boolean valid = mesg.verify(this.protocolVersion, this.handshakeHash, publicKey, this.session.getMasterSecret());
            if (!valid) {
                this.fatalSE((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException e) {
            this.fatalSE((byte)42, "certificate verify format error", e);
        }
        this.needClientVerify = false;
    }

    private void clientFinished(HandshakeMessage.Finished mesg) throws IOException {
        boolean verified;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if (this.doClientAuth == 2) {
            this.session.getPeerPrincipal();
        }
        if (this.needClientVerify) {
            this.fatalSE((byte)40, "client did not send certificate verify message");
        }
        if (!(verified = mesg.verify(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret()))) {
            this.fatalSE((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession && this.session.isRejoinable()) {
            ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).put(this.session);
            if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.session);
            }
        } else if (!this.resumingSession && debug != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.session);
        }
    }

    private void sendChangeCipherAndFinish(boolean finishedTag) throws IOException {
        this.output.flush();
        HandshakeMessage.Finished mesg = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret());
        this.sendChangeCipherSpec(mesg, finishedTag);
        if (finishedTag) {
            this.state = 20;
        }
    }

    HandshakeMessage getKickstartMessage() {
        return new HandshakeMessage.HelloRequest();
    }

    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription(description);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + message);
        }
        if (description == 41 && this.doClientAuth == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + message);
    }

    private SecretKey clientKeyExchange(RSAClientKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        return mesg.preMaster;
    }

    private void clientCertificate(HandshakeMessage.CertificateMsg mesg) throws IOException {
        X509Certificate[] peerCerts;
        if (debug != null && Debug.isOn("handshake")) {
            mesg.print(System.out);
        }
        if ((peerCerts = mesg.getCertificateChain()).length == 0) {
            if (this.doClientAuth == 1) {
                return;
            }
            this.fatalSE((byte)42, "null cert chain");
        }
        X509TrustManager tm = this.sslContext.getX509TrustManager();
        try {
            PublicKey key = peerCerts[0].getPublicKey();
            String keyAlgorithm = key.getAlgorithm();
            String authType = keyAlgorithm.equals("RSA") ? "RSA" : (keyAlgorithm.equals("DSA") ? "DSA" : (keyAlgorithm.equals("EC") ? "EC" : "UNKNOWN"));
            String identificator = this.getHostnameVerificationSE();
            if (tm instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)tm).checkClientTrusted(peerCerts != null ? (X509Certificate[])peerCerts.clone() : null, authType, this.getHostSE(), identificator);
            } else {
                if (identificator != null) {
                    throw new RuntimeException("trust manager does not support peer identification");
                }
                tm.checkClientTrusted(peerCerts != null ? (X509Certificate[])peerCerts.clone() : peerCerts, authType);
            }
        }
        catch (CertificateException e) {
            this.fatalSE((byte)46, e);
        }
        this.needClientVerify = true;
        this.session.setPeerCertificates(peerCerts);
    }
}

