/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmMemGCEntryImpl;
import sun.management.snmp.jvminstr.JvmMemManagerTableMetaImpl;
import sun.management.snmp.jvmmib.JvmMemGCTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemGCTableMetaImpl
extends JvmMemGCTableMeta {
    private transient JvmMemManagerTableMetaImpl managers = null;
    private static GCTableFilter filter = new GCTableFilter();
    static final MibLogger log = new MibLogger(JvmMemGCTableMetaImpl.class);

    public JvmMemGCTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
    }

    private final JvmMemManagerTableMetaImpl getManagers(SnmpMib mib) {
        if (this.managers == null) {
            this.managers = (JvmMemManagerTableMetaImpl)mib.getRegisteredTableMeta("JvmMemManagerTable");
        }
        return this.managers;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        JvmMemManagerTableMetaImpl managerTable = this.getManagers(this.theMib);
        return managerTable.getHandler(userData);
    }

    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        boolean dbg = log.isDebugOn();
        try {
            SnmpTableHandler handler;
            if (dbg) {
                log.debug("getNextOid", "previous=" + oid);
            }
            if ((handler = this.getHandler(userData)) == null) {
                if (dbg) {
                    log.debug("getNextOid", "handler is null!");
                }
                throw new SnmpStatusException(224);
            }
            SnmpOid next = filter.getNext(handler, oid);
            if (dbg) {
                log.debug("getNextOid", "next=" + next);
            }
            if (next == null) {
                throw new SnmpStatusException(224);
            }
            return next;
        }
        catch (RuntimeException x) {
            if (dbg) {
                log.debug("getNextOid", x);
            }
            throw x;
        }
    }

    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return filter.contains(handler, oid);
    }

    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        Object entry;
        String entryTag;
        if (oid == null) {
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        long index = oid.getOidArc(0);
        String string = entryTag = m == null ? null : "JvmMemGCTable.entry." + index;
        if (m != null && (entry = m.get(entryTag)) != null) {
            return entry;
        }
        SnmpTableHandler handler = this.getHandler(m);
        if (handler == null) {
            throw new SnmpStatusException(224);
        }
        Object data = filter.getData(handler, oid);
        if (data == null) {
            throw new SnmpStatusException(224);
        }
        JvmMemGCEntryImpl entry2 = new JvmMemGCEntryImpl((GarbageCollectorMXBean)data, (int)index);
        if (m != null && entry2 != null) {
            m.put(entryTag, entry2);
        }
        return entry2;
    }

    protected static class GCTableFilter {
        protected GCTableFilter() {
        }

        public SnmpOid getNext(SnmpCachedData datas, SnmpOid index) {
            int insertion;
            boolean dbg = log.isDebugOn();
            int n = insertion = index == null ? -1 : datas.find(index);
            if (dbg) {
                log.debug("GCTableFilter", "oid=" + index + " at insertion=" + insertion);
            }
            for (int next = insertion > -1 ? insertion + 1 : -insertion - 1; next < datas.indexes.length; ++next) {
                if (dbg) {
                    log.debug("GCTableFilter", "next=" + next);
                }
                Object value = datas.datas[next];
                if (dbg) {
                    log.debug("GCTableFilter", "value[" + next + "]=" + ((MemoryManagerMXBean)value).getName());
                }
                if (value instanceof GarbageCollectorMXBean) {
                    if (dbg) {
                        log.debug("GCTableFilter", ((MemoryManagerMXBean)value).getName() + " is a  GarbageCollectorMXBean.");
                    }
                    return datas.indexes[next];
                }
                if (!dbg) continue;
                log.debug("GCTableFilter", ((MemoryManagerMXBean)value).getName() + " is not a  GarbageCollectorMXBean: " + value.getClass().getName());
            }
            return null;
        }

        public SnmpOid getNext(SnmpTableHandler handler, SnmpOid index) {
            if (handler instanceof SnmpCachedData) {
                return this.getNext((SnmpCachedData)handler, index);
            }
            SnmpOid next = index;
            do {
                Object value;
                if (!((value = handler.getData(next = handler.getNext(next))) instanceof GarbageCollectorMXBean)) continue;
                return next;
            } while (next != null);
            return null;
        }

        public Object getData(SnmpTableHandler handler, SnmpOid index) {
            Object value = handler.getData(index);
            if (value instanceof GarbageCollectorMXBean) {
                return value;
            }
            return null;
        }

        public boolean contains(SnmpTableHandler handler, SnmpOid index) {
            return handler.getData(index) instanceof GarbageCollectorMXBean;
        }
    }
}

