/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LineBorder
extends AbstractBorder {
    private static Border blackLine;
    private static Border grayLine;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new LineBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new LineBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int thickness) {
        this(color, thickness, false);
    }

    public LineBorder(Color color, int thickness, boolean roundedCorners) {
        this.lineColor = color;
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            RectangularShape inner;
            RectangularShape outer;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.lineColor);
            int offs = this.thickness;
            int size = offs + offs;
            if (this.roundedCorners) {
                int arc = offs + size;
                outer = new RoundRectangle2D.Float(x, y, width, height, arc, arc);
                inner = new RoundRectangle2D.Float(x + offs, y + offs, width - size, height - size, arc, arc);
            } else {
                outer = new Rectangle2D.Float(x, y, width, height);
                inner = new Rectangle2D.Float(x + offs, y + offs, width - size, height - size);
            }
            Path2D.Float path = new Path2D.Float(0);
            path.append(outer, false);
            path.append(inner, false);
            g2d.fill(path);
            g2d.setColor(oldColor);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

