/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.ProcessMonitorThread;
import com.sun.corba.se.impl.activation.ServerTableEntry;
import com.sun.corba.se.impl.logging.ActivationSystemException;
import com.sun.corba.se.impl.oa.poa.BadServerIdHandler;
import com.sun.corba.se.spi.activation.EndPointInfo;
import com.sun.corba.se.spi.activation.InvalidORBid;
import com.sun.corba.se.spi.activation.LocatorPackage.ServerLocation;
import com.sun.corba.se.spi.activation.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.se.spi.activation.NoSuchEndPoint;
import com.sun.corba.se.spi.activation.ORBAlreadyRegistered;
import com.sun.corba.se.spi.activation.ORBPortInfo;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.Server;
import com.sun.corba.se.spi.activation.ServerAlreadyActive;
import com.sun.corba.se.spi.activation.ServerAlreadyInstalled;
import com.sun.corba.se.spi.activation.ServerAlreadyUninstalled;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotActive;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import com.sun.corba.se.spi.activation._ServerManagerImplBase;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.ForwardException;
import com.sun.corba.se.spi.transport.CorbaTransportManager;
import com.sun.corba.se.spi.transport.SocketOrChannelAcceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ServerManagerImpl
extends _ServerManagerImplBase
implements BadServerIdHandler {
    HashMap serverTable;
    Repository repository;
    CorbaTransportManager transportManager;
    int initialPort;
    ORB orb;
    ActivationSystemException wrapper;
    String dbDirName;
    boolean debug = false;
    private int serverStartupDelay;

    ServerManagerImpl(ORB orb, CorbaTransportManager transportManager, Repository repository, String dbDirName, boolean debug) {
        Class cls;
        this.orb = orb;
        this.wrapper = ActivationSystemException.get(orb, "orbd.activator");
        this.transportManager = transportManager;
        this.repository = repository;
        this.dbDirName = dbDirName;
        this.debug = debug;
        LegacyServerSocketEndPointInfo endpoint = orb.getLegacyServerSocketManager().legacyGetEndpoint("BOOT_NAMING");
        this.initialPort = ((SocketOrChannelAcceptor)((Object)endpoint)).getServerSocket().getLocalPort();
        this.serverTable = new HashMap(256);
        this.serverStartupDelay = 1000;
        String delay = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
        if (delay != null) {
            try {
                this.serverStartupDelay = Integer.parseInt(delay);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((cls = orb.getORBData().getBadServerIdHandler()) == null) {
            orb.setBadServerIdHandler(this);
        } else {
            orb.initBadServerIdHandler();
        }
        orb.connect(this);
        ProcessMonitorThread.start(this.serverTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(int serverId) throws ServerAlreadyActive, ServerNotRegistered, ServerHeldDown {
        block9: {
            ServerTableEntry entry;
            Integer key = new Integer(serverId);
            HashMap hashMap = this.serverTable;
            synchronized (hashMap) {
                entry = (ServerTableEntry)this.serverTable.get(key);
            }
            if (entry != null && entry.isActive()) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + serverId + " failed because server is already active. " + "entry = " + entry);
                }
                throw new ServerAlreadyActive(serverId);
            }
            try {
                entry = this.getEntry(serverId);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer called with  serverId=" + serverId + " endpointType=" + "IIOP_CLEAR_TEXT" + " block=false");
                }
                ServerLocation location = this.locateServer(entry, "IIOP_CLEAR_TEXT", false);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + serverId + " found location " + location.hostname + " and activated it");
                }
            }
            catch (NoSuchEndPoint ex) {
                if (!this.debug) break block9;
                System.out.println("ServerManagerImpl: activate for server Id  threw NoSuchEndpoint exception, which was ignored");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(int serverId, Server server) throws ServerNotRegistered {
        Integer key = new Integer(serverId);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry entry = (ServerTableEntry)this.serverTable.get(key);
            if (entry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: active for server Id " + serverId + " called, but no such server is registered.");
                }
                throw this.wrapper.serverNotExpectedToRegister();
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: active for server Id " + serverId + " called.  This server is now active.");
            }
            entry.register(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoints(int serverId, String orbId, EndPointInfo[] endpointList) throws NoSuchEndPoint, ServerNotRegistered, ORBAlreadyRegistered {
        Integer key = new Integer(serverId);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry entry = (ServerTableEntry)this.serverTable.get(key);
            if (entry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: registerEndpoint for server Id " + serverId + " called, but no such server is registered.");
                }
                throw this.wrapper.serverNotExpectedToRegister();
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: registerEndpoints for server Id " + serverId + " called.  This server is now active.");
            }
            entry.registerPorts(orbId, endpointList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getActiveServers() {
        int[] list = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry entry;
            ArrayList<ServerTableEntry> servers = new ArrayList<ServerTableEntry>(0);
            Iterator serverList = this.serverTable.keySet().iterator();
            try {
                while (serverList.hasNext()) {
                    Integer key = (Integer)serverList.next();
                    entry = (ServerTableEntry)this.serverTable.get(key);
                    if (!entry.isValid() || !entry.isActive()) continue;
                    servers.add(entry);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            list = new int[servers.size()];
            for (int i = 0; i < servers.size(); ++i) {
                entry = (ServerTableEntry)servers.get(i);
                list[i] = entry.getServerId();
            }
        }
        if (this.debug) {
            StringBuffer sb = new StringBuffer();
            for (int ctr = 0; ctr < list.length; ++ctr) {
                sb.append(' ');
                sb.append(list[ctr]);
            }
            System.out.println("ServerManagerImpl: getActiveServers returns" + sb.toString());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int serverId) throws ServerNotActive {
        Integer key = new Integer(serverId);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            block8: {
                ServerTableEntry entry = (ServerTableEntry)this.serverTable.remove(key);
                if (entry == null) {
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + serverId + " throws ServerNotActive.");
                    }
                    throw new ServerNotActive(serverId);
                }
                try {
                    entry.destroy();
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + serverId + " completed.");
                    }
                }
                catch (Exception e) {
                    if (!this.debug) break block8;
                    System.out.println("ServerManagerImpl: shutdown for server Id " + serverId + " threw exception " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerTableEntry getEntry(int serverId) throws ServerNotRegistered {
        Integer key = new Integer(serverId);
        ServerTableEntry entry = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            entry = (ServerTableEntry)this.serverTable.get(key);
            if (this.debug) {
                if (entry == null) {
                    System.out.println("ServerManagerImpl: getEntry: no active server found.");
                } else {
                    System.out.println("ServerManagerImpl: getEntry:  active server found " + entry + ".");
                }
            }
            if (entry != null && !entry.isValid()) {
                this.serverTable.remove(key);
                entry = null;
            }
            if (entry == null) {
                ServerDef serverDef = this.repository.getServer(serverId);
                entry = new ServerTableEntry(this.wrapper, serverId, serverDef, this.initialPort, this.dbDirName, false, this.debug);
                this.serverTable.put(key, entry);
                entry.activate();
            }
        }
        return entry;
    }

    private ServerLocation locateServer(ServerTableEntry entry, String endpointType, boolean block) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerLocation location = new ServerLocation();
        if (block) {
            String host;
            ORBPortInfo[] serverORBAndPortList;
            try {
                serverORBAndPortList = entry.lookup(endpointType);
            }
            catch (Exception ex) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server held down");
                }
                throw new ServerHeldDown(entry.getServerId());
            }
            location.hostname = host = this.orb.getLegacyServerSocketManager().legacyGetEndpoint("DEFAULT_ENDPOINT").getHostName();
            int listLength = serverORBAndPortList != null ? serverORBAndPortList.length : 0;
            location.ports = new ORBPortInfo[listLength];
            for (int i = 0; i < listLength; ++i) {
                location.ports[i] = new ORBPortInfo(serverORBAndPortList[i].orbId, serverORBAndPortList[i].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + location.hostname + " ORBid  " + serverORBAndPortList[i].orbId + " Port " + serverORBAndPortList[i].port);
            }
        }
        return location;
    }

    private ServerLocationPerORB locateServerForORB(ServerTableEntry entry, String orbId, boolean block) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerLocationPerORB location = new ServerLocationPerORB();
        if (block) {
            String host;
            EndPointInfo[] endpointInfoList;
            try {
                endpointInfoList = entry.lookupForORB(orbId);
            }
            catch (InvalidORBid ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServerForORB: server held down");
                }
                throw new ServerHeldDown(entry.getServerId());
            }
            location.hostname = host = this.orb.getLegacyServerSocketManager().legacyGetEndpoint("DEFAULT_ENDPOINT").getHostName();
            int listLength = endpointInfoList != null ? endpointInfoList.length : 0;
            location.ports = new EndPointInfo[listLength];
            for (int i = 0; i < listLength; ++i) {
                location.ports[i] = new EndPointInfo(endpointInfoList[i].endpointType, endpointInfoList[i].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + location.hostname + " endpointType  " + endpointInfoList[i].endpointType + " Port " + endpointInfoList[i].port);
            }
        }
        return location;
    }

    public String[] getORBNames(int serverId) throws ServerNotRegistered {
        try {
            ServerTableEntry entry = this.getEntry(serverId);
            return entry.getORBList();
        }
        catch (Exception ex) {
            throw new ServerNotRegistered(serverId);
        }
    }

    private ServerTableEntry getRunningEntry(int serverId) throws ServerNotRegistered {
        ServerTableEntry entry = this.getEntry(serverId);
        try {
            ORBPortInfo[] serverORBAndPortList = entry.lookup("IIOP_CLEAR_TEXT");
        }
        catch (Exception exc) {
            return null;
        }
        return entry;
    }

    public void install(int serverId) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyInstalled {
        ServerTableEntry entry = this.getRunningEntry(serverId);
        if (entry != null) {
            this.repository.install(serverId);
            entry.install();
        }
    }

    public void uninstall(int serverId) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyUninstalled {
        ServerTableEntry entry = (ServerTableEntry)this.serverTable.get(new Integer(serverId));
        if (entry != null) {
            entry = (ServerTableEntry)this.serverTable.remove(new Integer(serverId));
            if (entry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + serverId + " throws ServerNotActive.");
                }
                throw new ServerHeldDown(serverId);
            }
            entry.uninstall();
        }
    }

    public ServerLocation locateServer(int serverId, String endpointType) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry entry = this.getEntry(serverId);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServer called with  serverId=" + serverId + " endpointType=" + endpointType + " block=true");
        }
        return this.locateServer(entry, endpointType, true);
    }

    public ServerLocationPerORB locateServerForORB(int serverId, String orbId) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry entry = this.getEntry(serverId);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServerForORB called with  serverId=" + serverId + " orbId=" + orbId + " block=true");
        }
        return this.locateServerForORB(entry, orbId, true);
    }

    public void handle(ObjectKey okey) {
        IOR newIOR = null;
        ObjectKeyTemplate oktemp = okey.getTemplate();
        int serverId = oktemp.getServerId();
        String orbId = oktemp.getORBId();
        try {
            ServerTableEntry entry = this.getEntry(serverId);
            ServerLocationPerORB location = this.locateServerForORB(entry, orbId, true);
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle called for server id" + serverId + "  orbid  " + orbId);
            }
            int clearPort = 0;
            EndPointInfo[] listenerPorts = location.ports;
            for (int i = 0; i < listenerPorts.length; ++i) {
                if (!listenerPorts[i].endpointType.equals("IIOP_CLEAR_TEXT")) continue;
                clearPort = listenerPorts[i].port;
                break;
            }
            IIOPAddress addr = IIOPFactories.makeIIOPAddress(this.orb, location.hostname, clearPort);
            IIOPProfileTemplate iptemp = IIOPFactories.makeIIOPProfileTemplate(this.orb, GIOPVersion.V1_2, addr);
            if (GIOPVersion.V1_2.supportsIORIIOPProfileComponents()) {
                iptemp.add(IIOPFactories.makeCodeSetsComponent(this.orb));
                iptemp.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
            }
            IORTemplate iortemp = IORFactories.makeIORTemplate(oktemp);
            iortemp.add(iptemp);
            newIOR = iortemp.makeIOR(this.orb, "IDL:org/omg/CORBA/Object:1.0", okey.getId());
        }
        catch (Exception e) {
            throw this.wrapper.errorInBadServerIdHandler(e);
        }
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle throws ForwardException");
        }
        try {
            Thread.sleep(this.serverStartupDelay);
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
            e.printStackTrace();
        }
        throw new ForwardException(this.orb, newIOR);
    }

    public int getEndpoint(String endpointType) throws NoSuchEndPoint {
        return this.orb.getLegacyServerSocketManager().legacyGetTransientServerPort(endpointType);
    }

    public int getServerPortForType(ServerLocationPerORB location, String endPointType) throws NoSuchEndPoint {
        EndPointInfo[] listenerPorts = location.ports;
        for (int i = 0; i < listenerPorts.length; ++i) {
            if (!listenerPorts[i].endpointType.equals(endPointType)) continue;
            return listenerPorts[i].port;
        }
        throw new NoSuchEndPoint();
    }
}

