/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef NETWORKACCESSMANAGER_H
#define NETWORKACCESSMANAGER_H

#include <QNetworkAccessManager>

#include <QNetworkConfigurationManager>
#include <QNetworkConfiguration>
#include <QNetworkSession>

QTM_USE_NAMESPACE

class NetworkAccessManager : public QNetworkAccessManager {

    Q_OBJECT

    public:
        explicit NetworkAccessManager(QObject *parent = 0);

    protected:
        QNetworkReply *createRequest(Operation op, const QNetworkRequest &request, QIODevice *outgoingData = 0);

    private slots:
        void preferredNetworkConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless);
        void sslErrors(QNetworkReply *reply, const QList<QSslError> &errors);
        void finished(QNetworkReply *reply);

    private:
        QNetworkConfigurationManager *m_manager;
        QNetworkSession *m_session;

};

#endif // NETWORKACCESSMANAGER_H
