#include "extensions.h"
#include "mainwindow.h"
#include "webview.h"

#include <QDesktopServices>
#include <QDir>
#include <QWebSettings>
#include <QWebView>
#include <QWebFrame>

#ifdef Q_WS_S60
#include "qwebviewkineticscroller.h"
#endif

#ifdef Q_WS_MAEMO_5
#include "animatedstackedwidget.h"
#include "splashscreen.h"
#include <QTimer>
#include <QMessageBox>
#include <QApplication>
#endif


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    m_webView(new WebView(this)) {

#ifdef Q_WS_S60
    QWebViewKineticScroller *scroller = new QWebViewKineticScroller();
    scroller->setWidget(m_webView);
#endif

#ifdef Q_WS_MAEMO_5
    QPalette pal = palette();
    pal.setColor(backgroundRole(), Qt::white);
    setPalette(pal);

    SplashScreen *splash = new SplashScreen(m_webView);
    AnimatedStackedWidget *stackedWidget = new AnimatedStackedWidget();

    stackedWidget->addWidget(splash);
    stackedWidget->addWidget(m_webView);
    setCentralWidget(stackedWidget);

    connect(m_webView, SIGNAL(loadFinished(bool)), this, SLOT(loadFinished(bool)));
    connect(m_webView, SIGNAL(loadProgress(int)), splash, SLOT(setProgress(int)));
#else
    setCentralWidget(m_webView);
#endif
    m_webView->settings()->setAttribute(QWebSettings::LocalContentCanAccessRemoteUrls, true);

    new Extensions(m_webView);

    QDir templateDir = QDir::current();
#ifdef Q_WS_SIMULATOR
    templateDir.cdUp();
#endif
    templateDir.cd("template");

    m_webView->settings()->enablePersistentStorage();
    m_webView->settings()->setLocalStoragePath(QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/storage");

#ifdef Q_WS_MAEMO_5
    //: locale selecting which language-version of the Hybrid app is being loaded on startup (currently 'en_US' and 'nl_NL' are supported only)
    m_webView->load(QUrl("http://www.hyves.nl/hybrid/?&locale=" + tr("en_US")));
#else
    m_webView->load(QUrl::fromUserInput(templateDir.filePath("index.html")));
#endif
}

MainWindow::~MainWindow() {
}

#ifdef Q_WS_MAEMO_5
void MainWindow::loadFinished(bool success) {

    if (success && m_webView->page()->mainFrame()->evaluateJavaScript("typeof($('#loader'))") == "object") {
        initialized();
        return;
    }

    //: something went wrong during initialization, ask user whether he wants to try to reconnect or quit the application
    if (QMessageBox::question(this, tr("Failed to connect..."), tr("Try again?"), QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes) {
        m_webView->reload();
    } else {
        qApp->quit();
    }
}

void MainWindow::initialized() {

    if (m_webView->page()->mainFrame()->evaluateJavaScript("typeof($('#loader'))") == "undefined") {
        qDebug("Hybrid not yet loaded...");
        QTimer::singleShot(250, this, SLOT(initialized()));
        return;
    }

    // hide splash screen
    AnimatedStackedWidget *stackedWidget = qobject_cast<AnimatedStackedWidget*>(centralWidget());
    if (stackedWidget) {
        stackedWidget->setCurrentWidget(m_webView);
    }
}
#endif
