#include "gapapplication.h"

#ifdef Q_OS_SYMBIAN
#include <QSymbianEvent>
#include <QSettings>
#include <QTimer>
#include <apgtask.h>
#include <w32std.h>

static const int KGoomMemoryLowEvent = 0x10282DBF;
#endif


GapApplication::GapApplication(int &argc, char *argv[]) :
    QApplication(argc, argv) {
}

#ifdef Q_OS_SYMBIAN
/**
 * Prevent GOOM from shutting us down when the phone runs low on graphics memory
 * @see http://wiki.forum.nokia.com/index.php/Graphics_memory_handling
 */
bool GapApplication::symbianEventFilter(const QSymbianEvent *symbianEvent) {

    const TWsEvent *event = symbianEvent->windowServerEvent();
    if (event && event->Type() == EEventUser) {
        TApaSystemEvent *eventData = reinterpret_cast<TApaSystemEvent*>(event->EventData());
        if (*eventData == EApaSystemEventShutdown && *(++eventData) == KGoomMemoryLowEvent) {
            qDebug("GapApplication::symbianEventFilter(): KGoomMemoryLowEvent");
            QSettings s;
            s.setValue("stats/killedByGoom", s.value("stats/killedByGoom", 0).toInt() + 1); // increment kill counter
            s.sync();
            QTimer::singleShot(10000, this, SLOT(survivedGoomEvent())); // decrement counter if we survice the next 10 sec...
            return true;
        }
    }

    return false;
}

void GapApplication::survivedGoomEvent() {

    qDebug("GapApplication: survived KGoomMemoryLowEvent");
    QSettings s;
    s.setValue("stats/killedByGoom", s.value("stats/killedByGoom", 0).toInt() - 1); // decrement kill counter
}

#endif
