/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "animatedstackedwidget.h"

#include <QStackedLayout>
#include <QEasingCurve>
#include <QPropertyAnimation>
#include <QGraphicsOpacityEffect>

AnimatedStackedWidget::AnimatedStackedWidget(QWidget *parent) :
    QWidget(parent),
    m_layout(new QStackedLayout(this)) {
    m_layout->setStackingMode(QStackedLayout::StackAll);
    setLayout(m_layout);

    connect(m_layout, SIGNAL(currentChanged(int)), this, SIGNAL(currentChanged(int)));
    connect(m_layout, SIGNAL(widgetRemoved(int)), this, SIGNAL(widgetRemoved(int)));
}

int AnimatedStackedWidget::addWidget(QWidget *widget) {

    if (!m_layout->isEmpty()) {
        widget->hide();
    }
    return m_layout->addWidget(widget);
}

int AnimatedStackedWidget::currentIndex() const {

    return m_layout->currentIndex();
}

QWidget *AnimatedStackedWidget::currentWidget() const {

    return m_layout->currentWidget();
}

int AnimatedStackedWidget::insertWidget(int index, QWidget *widget) {

    if (!m_layout->isEmpty()) {
        widget->hide();
    }
    return m_layout->insertWidget(index, widget);
}

QWidget *AnimatedStackedWidget::widget(int index) const {

    return m_layout->widget(index);
}


void AnimatedStackedWidget::setCurrentIndex(int index) {

    setCurrentWidget(m_layout->widget(index));
}

void AnimatedStackedWidget::setCurrentWidget(QWidget *widget) {

    QWidget *current = m_layout->currentWidget();
    if (!widget || !current || widget == current) {
        return;
    }

    QGraphicsOpacityEffect *effect = new QGraphicsOpacityEffect(widget);
    connect(effect, SIGNAL(opacityChanged(qreal)), widget, SLOT(repaint()));
    widget->setGraphicsEffect(effect);
    effect->setEnabled(true);
    effect->setOpacity(0);
    widget->show();

    m_layout->setCurrentWidget(widget);

    QPropertyAnimation *animation = new QPropertyAnimation(effect, "opacity", this);
    connect(animation, SIGNAL(finished()), current, SLOT(hide()));
    connect(animation, SIGNAL(finished()), this, SLOT(animationFinished()));
    animation->setDuration(1000);
    animation->setStartValue(0.01);
    animation->setEndValue(0.99);
    animation->setEasingCurve(QEasingCurve::InSine);
    animation->start(QAbstractAnimation::DeleteWhenStopped);
}

void AnimatedStackedWidget::animationFinished() {

    QWidget *widget = m_layout->currentWidget();
    if (widget) {
        widget->setGraphicsEffect(0);
        widget->repaint();
    }
}
