/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef THUMBNAILLOADER_H
#define THUMBNAILLOADER_H

#include <QObject>
#include <QRunnable>
#include <QByteArray>

class ThumbnailLoader : public QObject
{
    Q_OBJECT
public:
    explicit ThumbnailLoader(QObject *parent = 0);
    virtual ~ThumbnailLoader();

    void loadImage(const QString &path);

signals:
    void thumbLoaded(const QByteArray &data);

private:
    friend class ThumbnailLoaderRunnable;
    Q_INVOKABLE void done();

    bool m_running;
    QString m_path;
    QByteArray m_imgData;
};

class ThumbnailLoaderRunnable : public QRunnable
{
public:
    ThumbnailLoaderRunnable(ThumbnailLoader *loader);
    virtual void run();

private:
    ThumbnailLoader *m_loader;
};

#endif // THUMBNAILLOADER_H
