/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef UTILITY_H
#define UTILITY_H

#include <QObject>

class QWebView;

/**
 * @class Utility - Provides all sorts of extra functionality not specified in the
 * official Phonegap API.
 * @note Make sure to check avalability before accessing any members from js-code
 * (or you might break compatibility with other platforms)
*/
class Utility : public QObject {

    Q_OBJECT

    public:
        explicit Utility(QWebView *webView, QObject *parent = 0);

        /**
         * Exits the application
         */
        Q_INVOKABLE void exit();

        /**
         * Opens @param url in external web-browser
         */
        Q_INVOKABLE void openUrl(const QString &url);

        /**
         * Forces webkit to repaint it's contents immediately
         */
        Q_INVOKABLE void forceRepaint();

        /**
         * Purges the network disk cache
         */
        Q_INVOKABLE void purgeCache();

        /**
         * Get/Set the locale(language) loaded during application startup
         * Changes will take effect on next spplication start.
         *
         * @note: Container falls back to english if invalid/non-existing values are
         * specified
         */
        Q_PROPERTY(QString locale READ locale WRITE setLocale);

        /**
         * Sets the application locale
         * @param name, e.g. 'nl_NL' or 'en_US' if ommitted/empty string the system locale will be used
         */
        void setLocale(const QString &name = "");

        /**
         * @returns the current locale
         */
        QString locale() const;

    private:
        QWebView *m_webView;
};

#endif // UTILITY_H
