/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef HYVESUPLOAD_H
#define HYVESUPLOAD_H

#include <QSize>
#include <QObject>
#include <QVariantMap>

class QNetworkAccessManager;


class HyvesUpload : public QObject {

    Q_OBJECT

    public:
        explicit HyvesUpload(QNetworkAccessManager *nam, QObject *parent = 0);

        Q_INVOKABLE void uploadFile(const QString &ip, const QString &token,
                                    const QString &path, const QVariantMap &properties = QVariantMap());

        /**
         * Images are scaled down to @param maxImageWidth before uploading if necessary
         * @note The original image on the phone will not be modified
         */
        Q_PROPERTY(int maxImageWidth READ maxImageWidth WRITE setMaxImageWidth);
        int maxImageWidth() const;
        void setMaxImageWidth(int value);

        /**
         * Images are scaled down to @param maxImageHeight before uploading if necessary
         * @note The original image on the phone will not be modified
         */
        Q_PROPERTY(int maxImageHeight READ maxImageHeight WRITE setMaxImageHeight);
        int maxImageHeight() const;
        void setMaxImageHeight(int value);

        QByteArray loadImage(const QString &path) const;

    signals:
        void uploadProgress(int progress);

        void uploadSucceeded(QString mediaId);

        void uploadFailed();

    private:
        QNetworkAccessManager *m_nam;
        QSize m_maxImageSize;

    private slots:
        void handleUploadFinished();
        void requestStatusUpdate(const QString &host, const QString &token);
        void handleStatusFinished();
        void handleUploadProgress(qint64 bytesSent, qint64 bytesTotal);
};

#endif // HYVESUPLOAD_H
