#include "extensions.h"
//#include "extensions/accelerometer.h"
#include "extensions/camera.h"
#include "extensions/debugconsole.h"
#include "extensions/deviceinfo.h"
#include "extensions/geolocation.h"
#include "extensions/hyvesupload.h"
#include "extensions/notification.h"
#include "extensions/oauthutil.h"
#include "extensions/profiling.h"
#include "extensions/utility.h"
#include "webview.h"

#ifdef Q_WS_S60
#include "extensions/memorywatcher.h"
#endif

#include <QWebFrame>


Extensions::Extensions(WebView *webView) :
    QObject(webView) {

    m_frame = webView->page()->mainFrame();
    connect(m_frame, SIGNAL(javaScriptWindowObjectCleared()), SLOT(attachExtensions()));

    //m_extensions["GapAccelerometer"] = new Accelerometer(this);
    m_extensions["GapCamera"] = new Camera(this);
    m_extensions["GapDebugConsole"] = DebugConsole::instance();
    m_extensions["GapDeviceInfo"] = new DeviceInfo(this);
    m_extensions["GapGeolocation"] = new Geolocation(this);
    m_extensions["GapHyvesUpload"] = new HyvesUpload(webView->page()->networkAccessManager(), this);
    m_extensions["GapNotification"] = new Notification(this);
    m_extensions["GapOAuthUtil"] = new OAuthUtil(this);
    m_extensions["GapProfiling"] = Profiling::instance();
    m_extensions["GapUtility"] = new Utility(webView, this);

#ifdef Q_WS_S60
    m_extensions["GapMemoryWatcher"] = new MemoryWatcher(this);
#endif

    attachExtensions();
}

void Extensions::attachExtensions() {

    foreach (QString name, m_extensions.keys()) {
        m_frame->addToJavaScriptWindowObject(name, m_extensions[name]);
    }
}
