# -*- coding: iso-8859-15 -*-
###################################################
#
# HXM heart beat HXMConnection
# Version 15.2.2010
# Jari Multisilta
#
##################################################

import gtk
import hildon
from bluetooth import *
import threading
import pdb
import time
from struct import *
from time import strftime
from dprint import *
import os


# Because the application is multi-threaded, this is keep it thread-safe
_bclock = threading.Lock()

class HXMConnection(threading.Thread):
 def __init__(self, parent):
   self.parent = parent
   self.isConnected = False
   self.lastKnownHeading = 0
   threading.Thread.__init__(self)

 def run(self):
   dprint("IN: HXM Connection.connect")
   target_name = "HXM"
   target_address = None
   number_of_tries = 2

   # Loop a couple times in case the device/name isn't found the first time
   while target_address is None and number_of_tries > 0:
     number_of_tries = number_of_tries - 1

     # Discover bluetooth devices in the vicinity
     dprint("Searching for HXM...")
     self.parent.msg = "Searching"
     time.sleep(0.1)

####
### The HXM belt may be defined in hxmprefs.txt file
###

     try:
       dprint("Reading file: hxmprefs.txt")
       path_name = os.path.expanduser('~')+"/.hxmpref.txt"
       tiedosto = open(path_name, "r")
       rivit = tiedosto.readlines()
       btaddress = rivit[0]
       tiedosto.close()
       slen = len(btaddress.split())
       target_address = btaddress.split()[slen-1]
       dprint("BTAdress from hxmprefs.txt: " + target_address)
     except:
       dprint("File hxmpref.txt does not exist")
       target_address = None

    # The HXM address was not in prefs file, try to find a HXM belt
     if target_address is None:
        try:
          nearby_devices = discover_devices()
        except:
          nearby_devices = ""
          dprint("Discover devices fail")

     # Loop through each device and check its name for a prefix match
        for btaddr in nearby_devices:
          btname = lookup_name(btaddr)
          dprint(" -Found device: %s (%s)" % (btname, btaddr))
          if btname == None:
         	btname = "None"
          mjono = "Found " + btname
          self.parent.msg = mjono
          time.sleep(0.1) 
          if btname is not None and btname.startswith(target_name) == True:
            # Use the first device it finds that matches name
            dprint("Found HXM.")
            self.parent.msg = "Found HXM"
            time.sleep(0.1) 
            target_address = btaddr
            dprint("Found HXM BTAddress: " + btaddr)
            break

   if target_address is not None:
     # Begin the actual connection device using BT network socket communication
     self.sock=BluetoothSocket( RFCOMM )
     try: self.sock.connect((target_address, 1))
     except:
       dprint("Unable to connect to HXM")
       self.parent.msg = "Unable to connect to HXM"
       time.sleep(0.1) 
       self.isConnected = False
       self.sock.close()
     else:
       # if connection succeeded, create the multi-thread "receiver"
       # which will handle receiving data in the background automatically
       dprint("Connected to HXM (%s)" % (target_address))
       self.parent.msg = "Connected to HXM"
       time.sleep(0.1) 
       self.isConnected = True
       self.parent.connection = True
       self.receiver = __ReceiverThread__(self)
       self.receiver.start()
   else:
     dprint("Could not locate HXM.")
     self.parent.msg = "Could not locate HXM"
     self.isConnected = False


 def getCurrentHeading(self):
   heading = 0
   # Acquire a thread lock (for safety) and return the last received heading
   _bclock.acquire()
   try: heading = self.lastKnownHeading
   finally: _bclock.release()
   return heading

 def getCurrentBat(self):
   bat = "---- "
   batval = 0
   # Acquire a thread lock (for safety) and return the last received heading
   _bclock.acquire()
   try: batval = self.bat
   finally: _bclock.release()
   
   if batval > 90:
        bat = "B:**** "
   elif batval > 75:
	bat = "B:***- "
   elif batval > 50:
	bat = "B:**-- "
   elif batval > 25:
	bat = "B:*--- "
   else:
	bat = "B:---- "
   return bat


 def disconnect(self):
   # If connected, do the socket cleanup stuff
   if self.isConnected == True:
     self.sock.close()
     self.isConnected = False
     self.parent.msg = "Disconnected from HXM"
     dprint("Disconnected from HXM")

#
# This is a private class that uses threading to receive data from the HXM
#
class __ReceiverThread__ (threading.Thread):
 def __init__(self, parent):
   self.parent = parent
   threading.Thread.__init__(self)


 def write_to_file(self, rivi):
   file_ok = False
   path_name = os.path.expanduser('~')+"/.hxmlog.txt"
   try:
     tulostiedosto = open(path_name, "a")
     file_ok = True
   except:
     dprint("Tiedostoa ",path_name," ei voi avata")
     file_ok = False 
   try:
     if file_ok == True:
      tulostiedosto.write(rivi + "\n")
   except:
      dprint("Tiedostoon ",path_name," ei voi kirjoittaa")

   if file_ok == True:
      try:
        tulostiedosto.close()
      except:
        dprint("Tiedostoa ",path_name," ei voi sulkea")

 def writecoord_to_xmlfile(self, rivi):
   file_ok = False
   path_name = os.path.expanduser('~')+"/.coord.xml"
   try:
     tulostiedosto = open(path_name, "a")
     file_ok = True
   except:
     dprint("XML-tiedostoa ",path_name," ei voi avata")
     file_ok = False
   try:
     if file_ok == True:
      tulostiedosto.write(rivi + "\n")
   except:
      dprint("XML-tiedostoon  ",path_name, " ei voi kirjoittaa")

   if file_ok == True:
      try:
        tulostiedosto.close()
      except:
        dprint("XML-tiedostoa ",path_name," ei voi sulkea")

 def run(self):
   data = ""
   file_ok = False
   xmldata = '<coords date="'+strftime("%d.%m.%Y")+'" starttime="'+strftime("%H:%M:%S")+'">'
   self.writecoord_to_xmlfile(xmldata)
 
   while self.parent.isConnected == True:

     # Wait indefinitely until a byte is received.  This is likely not the
     # best way to do this.  For production, it would be better to use the
     # 'select' module to get notification when data is ready.

     try:
     	data = self.parent.sock.recv(1024)
     except:
	dprint("Bluetooth -yhteyden lukeminen ei onnistunut")
        data =""

     # Verify received
     if data != "":
            if len(data) > 58:
		  if ord(data[2]) == 55:

                     # Heart beat, valid range 30..240
                     syke = ord(data[12])

                     # Battery index, 0..100%
                     bat = ord(data[11])

                     # Heart beat number, valid range 0..255
                     sykenro = ord(data[13])

                     # Data in 50 is distance, valid range 0..256 m
                     byte2 = unpack_from('h',data,50)[0]
                     distance = byte2/16
  
                     # Data in 52 is instanteous speed, 0 - 15,996 m/s
                     byte2 = unpack_from('h',data,52)[0]
                     speed = float(byte2/256)

                     # Strides = steps, askelmittaus, arvot 0-127
                     steps = ord(data[54])
                     steps = unpack_from('b',data,54)[0]

                     # Data in 56 is cadence, steps/min
                     byte2 = unpack_from('h',data,56)[0]
                     cadence = float(byte2/256)

                     # GPS position
                     _bclock.acquire()
                     try: lat = self.parent.parent.lat
                     finally: _bclock.release()

                     _bclock.acquire()
                     try: lon = self.parent.parent.lon
                     finally: _bclock.release()


                     rivi = (strftime("%d.%m.%Y, %H:%M:%S")+", "+str(syke)+", "+str(sykenro)+", "
                            +str(distance)+", "+str(speed)+", "+str(steps)+", "+str(cadence)
                            +", "+str(bat)+", "+str(lat)+", "+str(lon))

                     self.write_to_file(rivi)

                     xmldata = ("<coord><lat>"+str(lat)+"</lat><lon>"+str(lon)+"</lon><syke>"+str(syke)
                               +"</syke><time>"+strftime("%H:%M:%S")+"</time></coord>")
                                              
                     self.writecoord_to_xmlfile(xmldata)

                     _bclock.acquire()
                     try: self.parent.lastKnownHeading = syke
                     finally: _bclock.release()
 
                     _bclock.acquire()
                     try: self.parent.bat = bat
                     finally: _bclock.release()
     else:
       # If nothing was received, this usually means the socket closed from the
       # remote end, so notify that the belt is disconnected.
       dprint("Remote client disconnected")
       self.parent.msg = "Remote client disconnected"
       self.parent.disconnect()
   # while loop ends here 
   self.writecoord_to_xmlfile("</coords>")
   




