#include "stundenplan.h"
#include <QDebug>
#include <QStringList>

StundenplanItem::StundenplanItem(){
    ds = 0;
    ds_start.setHMS(7,30,0);
    ds_end.setHMS(9,0,0);
    tag = 0;
    text1 = "";
    text2 = "";
    text3 = "";
}
StundenplanItem::StundenplanItem(const StundenplanItem &s){
    ds = s.ds;
    ds_start = s.ds_start;
    ds_end = s.ds_end;
    tag = s.tag;
    text1 = s.text1;
    text2 = s.text2;
    text3 = s.text3;
}
StundenplanItem::StundenplanItem(int doppelstunde, int tag, QString beschreibung, QString kurzbeschreibung, QString raum){
    setAll(doppelstunde, tag, beschreibung, kurzbeschreibung, raum);
}
StundenplanItem::StundenplanItem(int doppelstunde, int tag, QStringList liste){
    setAll(doppelstunde,tag,liste);
}

bool StundenplanItem::operator ==(StundenplanItem vgl){
    if(
            (ds == vgl.ds) &&
            (ds_start == vgl.ds_start) &&
            (ds_end == vgl.ds_end) &&
            (tag == vgl.tag) &&
            (text1 == vgl.text1) &&
            (text2 == vgl.text2) &&
            (text3 == vgl.text3)
      ){
        return true;
    }
    return false;
}
bool StundenplanItem::operator !=(StundenplanItem vgl){
    return !(*this == vgl);
}
StundenplanItem &StundenplanItem::operator =(const StundenplanItem &s){
    if(this != &s){
        ds = s.ds;
        ds_start = s.ds_start;
        ds_end = s.ds_end;
        tag = s.tag;
        text1 = s.text1;
        text2 = s.text2;
        text3 = s.text3;
    }
    return *this;
}

int StundenplanItem::getDoppelstunde() const {
    return ds+1;
}
QTime StundenplanItem::getDoppelstundeStart() const {
    return ds_start;
}
QTime StundenplanItem::getDoppelstundeEnde() const {
    return ds_end;
}
int StundenplanItem::getWochentag() const {
    return tag;
}
QString StundenplanItem::getBeschreibung() const {
    return text1;
}
QString StundenplanItem::getKurzbeschreibung() const {
    return text2;
}
QString StundenplanItem::getRaum() const {
    return text3;
}
QList<QString> StundenplanItem::getAllText() const {
    QList<QString> tmp;
    tmp.append(text1);
    tmp.append(text2);
    tmp.append(text3);
    return tmp;
}

void StundenplanItem::setDoppelstunde(int doppelstunde){
    switch(doppelstunde){
    case 1: ds = 0;
        ds_start.setHMS(7,30,0);
        ds_end.setHMS(9,0,0);
        break;
    case 2: ds = 1;
        ds_start.setHMS(9,20,0);
        ds_end.setHMS(10,50,0);
        break;
    case 3: ds = 2;
        ds_start.setHMS(11,10,0);
        ds_end.setHMS(12,40,0);
        break;
    case 4: ds = 3;
        ds_start.setHMS(13,10,0);
        ds_end.setHMS(14,40,0);
        break;
    case 5: ds = 4;
        ds_start.setHMS(15,0,0);
        ds_end.setHMS(16,30,0);
        break;
    case 6: ds = 5;
        ds_start.setHMS(16,50,0);
        ds_end.setHMS(18,20,0);
        break;
    case 7: ds = 6;
        ds_start.setHMS(18,30,0);
        ds_end.setHMS(20,0,0);
        break;
    case 8: ds = 7;
        ds_start.setHMS(20,0,0);
        ds_end.setHMS(23,59,59);
        break;
    }
}
void StundenplanItem::setWochentag(int tag){
    this->tag = tag;
}
void StundenplanItem::setBeschreibung(QString b){
    text1 = b;
}
void StundenplanItem::setKurzbeschreibung(QString kb){
    text2 = kb;
}
void StundenplanItem::setRaum(QString r){
    text3 = r;
}
void StundenplanItem::setAllText(QList<QString> liste){
    switch(liste.size()){
    case 1: text1 = liste[0].simplified();
        text2 = "";
        text3 = "";
        break;
    case 2: text1 = liste[0].simplified();
        text2 = liste[1].simplified();
        text3 = "";
        break;
    case 3: text1 = liste[0].simplified();
        text2 = liste[1].simplified();
        text3 = liste[2].simplified();
        break;
    default: text1 = "";
        text2 = "";
        text3 = "";
    }
}
void StundenplanItem::setAll(int doppelstunde, int tag, QString beschreibung, QString kurzbeschreibung, QString raum){
    setDoppelstunde(doppelstunde);
    this->tag = tag;
    text1 = beschreibung;
    text2 = kurzbeschreibung;
    text3 = raum;
}
void StundenplanItem::setAll(int doppelstunde, int tag, QStringList liste){
    setDoppelstunde(doppelstunde);
    this->tag = tag;
    switch(liste.size()){
    case 1: text1 = liste[0].simplified();
        text2 = "";
        text3 = "";
        break;
    case 2: text1 = liste[0].simplified();
        text2 = liste[1].simplified();
        text3 = "";
        break;
    case 3: text1 = liste[0].simplified();
        text2 = liste[1].simplified();
        text3 = liste[2].simplified();
        break;
    default: text1 = "";
        text2 = "";
        text3 = "";
    }
}


QDataStream &operator<<(QDataStream &out, const StundenplanItem &obj)
{
     out << obj.getDoppelstunde() << obj.getWochentag() << obj.getBeschreibung() << obj.getKurzbeschreibung() << obj.getRaum();
     return out;
}
QDataStream &operator>>(QDataStream &in, StundenplanItem &obj)
{
    int d = 0;
    int t = 0;
    QString t1 = "";
    QString t2 = "";
    QString t3 = "";
    in >> d >> t >> t1 >> t2 >> t3;
    obj.setAll(d,t,t1,t2,t3);
    return in;
}

Stundenplan::Stundenplan(QString fname, QObject *parent) :
    QObject(parent)
{
    qRegisterMetaType<StundenplanItem>("StundenplanItem");
    qRegisterMetaTypeStreamOperators<StundenplanItem>("StundenplanItem");
    einstellungen = new QSettings(fname,QSettings::IniFormat);
    this->lastupdatekw=0;
    this->autoupdate=false;
    this->autowriteaenderungen=false;
    this->matrikelnummer="";
    this->imm_jahr="";
    this->studiengang="";
    this->gruppe="";
    manager = new QNetworkAccessManager();
    connect(manager,SIGNAL(finished(QNetworkReply*)),this,SLOT(replyFinished(QNetworkReply*)));
}

void Stundenplan::readPlan(QString imjahr, QString studiengang, QString gruppe){
    QByteArray tmp = QString("imm="+imjahr+"&stuga="+studiengang+"&grup="+gruppe+"&lang=1&aktkw=1&pressme=S+T+A+R+T&matr=&unix=&passi=").toAscii();
    manager->post(QNetworkRequest(QUrl("http://www2.htw-dresden.de/~rawa/cgi-bin/auf/raiplan.php")),tmp);
}
void Stundenplan::readPlan(QString matnr){
    QByteArray tmp = QString("imm=&stuga=&matr="+matnr+"&lang=1&aktkw=1&pressme=S+T+A+R+T&unix=&passi=").toAscii();
    manager->post(QNetworkRequest(QUrl("http://www2.htw-dresden.de/~rawa/cgi-bin/auf/raiplan.php")),tmp);
}
void Stundenplan::readPlan(){
    if(matrikelnummer!=""){
        readPlan(matrikelnummer);
    }
    else{
        if((imm_jahr!="")&&(studiengang!="")&&(gruppe!="")){
            readPlan(imm_jahr,studiengang,gruppe);
        }
    }
}

void Stundenplan::clearPlan(){
    for(int i=0;i<2;i++){
        for(int j=0;j<7;j++){
            stundenplan[i][j].clear();
        }
    }
}

void Stundenplan::replyFinished(QNetworkReply *reply){
    QString tmp;
    QStringList tabs;  // 4 Tabs
    QStringList zeilen[4]; //4 Tabellen* 8 Zeilen
    QStringList spalten[4][8]; //4 Tabs * 8 Zeilen * 6 Spalten
    Kalenderwoche kw;
    clearPlan();
    if(reply->error()==QNetworkReply::NoError){
        tmp = reply->readAll();

        /* HTML Tabellen zeugs entfernen */
        tmp.remove(0,tmp.indexOf("<table cellpadding=5 border>"));
        tmp.resize(tmp.lastIndexOf("</table><br><br>")+QString("</table>").size());
        tmp.remove("<table cellpadding=5 border><tr align=center><td class=menu2>");
        tmp.remove("<table>");
        tmp.remove("<td class=menu3>");
        tmp.remove("<td>");
        tmp.remove("<tr align=center>");
        tmp.remove("<tr>");
        tmp.remove("<br><br>");

        /* Splitten */
        tabs = tmp.split("</table>",QString::SkipEmptyParts);
        for(int i=0;i<tabs.size();i++){
            tabs[i] = tabs[i].simplified();
            zeilen[i] = tabs[i].split("</tr>", QString::SkipEmptyParts);
            for(int j=0;j<zeilen[i].size();j++){
                zeilen[i][j] = zeilen[i][j].simplified();
                spalten[i][j]= zeilen[i][j].split("</td>", QString::SkipEmptyParts);
                for(int k=0;k<spalten[i][j].size();k++){
                    spalten[i][j][k] = spalten[i][j][k].simplified();
                    spalten[i][j][k].remove("&nbsp;");
                }
            }
        }

        /* In Stundenplan speichern */
        for(int i=0;i<2;i++){
            tmp = spalten[i][0][0];
            tmp.truncate(2);
            if(tmp.toInt()%2==0) kw=gerade;
            else kw = ungerade;
            for(int j=1;j<8;j++){
                for(int k=1;k<spalten[i][j].size();k++){
                    if(spalten[i][j][k]!="") stundenplan[kw][k-1].append(StundenplanItem(j,k-1,spalten[i][j][k].split("<br>", QString::SkipEmptyParts)));
                }
            }
        }
        lastupdatekw = QDate::currentDate().weekNumber();
        emit planReaded();
    }
    else {
        emit connectionError();
    }
}

StundenplanItem Stundenplan::getAenderung(Kalenderwoche kw, int index){
    if((index>=0)&& (index<aenderungen[kw].size())){
        return aenderungen[kw][index];
    }
    return StundenplanItem(1,6,"error","error","error");
}
QList<StundenplanItem> Stundenplan::getAenderung(Kalenderwoche kw){
    return aenderungen[kw];
}

StundenplanItem Stundenplan::getStundenplan(Kalenderwoche kw, int tag, int ds){
    if( ((tag>=0)&&(tag<7)) && ((ds>0)&&(ds<8)) ){
        for(int i=0;i<stundenplan[kw][tag].size();i++){
            if(stundenplan[kw][tag][i].getDoppelstunde()==ds) return stundenplan[kw][tag][i];
        }
        return StundenplanItem(ds,tag,"","","");
    }
    return StundenplanItem(1,6,"error","error","error");
}

QList<StundenplanItem> Stundenplan::getStundenplan(Kalenderwoche kw, int tag){
    if((tag>=0)&&(tag<7)){
        return stundenplan[kw][tag];
    }
    return QList<StundenplanItem>();
}

StundenplanItem Stundenplan::getCurrenStundenplan(int vorlaufzeit){
    QTime akt_zeit = QTime::currentTime();
    QDate akt_datum = QDate::currentDate();
    Kalenderwoche kw = gerade;

    if(akt_datum.weekNumber()%2!=0) kw = ungerade;

    if(stundenplan[kw][akt_datum.dayOfWeek()-1].size()>0){
        for(int i = 0;i<stundenplan[kw][akt_datum.dayOfWeek()-1].size();i++){
            if(stundenplan[kw][akt_datum.dayOfWeek()-1][i].getDoppelstundeEnde()>=akt_zeit){
                return stundenplan[kw][akt_datum.dayOfWeek()-1][i];
            }
        }
        return StundenplanItem(8,akt_datum.dayOfWeek()-1,"","Feierabend","");
    }
    return StundenplanItem(8,akt_datum.dayOfWeek()-1,"","Heute ist frei.","");
}

void Stundenplan::addAenderung(Kalenderwoche kw, StundenplanItem a){
    for(int i=0;i<aenderungen[kw].size();i++){
        if(aenderungen[kw][i].getDoppelstunde()==a.getDoppelstunde()){
            aenderungen[kw].replace(i,a);
            return;
        }
    }
    aenderungen[kw].append(a);
}
void Stundenplan::removeAenderung(Kalenderwoche kw, int index){
    if((index>=0)&&(index<aenderungen[kw].size())){
        aenderungen[kw].removeAt(index);
    }
}
void Stundenplan::removeAenderung(Kalenderwoche kw, StundenplanItem a){
    aenderungen[kw].removeOne(a);
}
void Stundenplan::removeAllAenderung(){
    aenderungen[0].clear();
    aenderungen[1].clear();
}
void Stundenplan::writeAllAenderung(){
    for(int i=0;i<2;i++){
        for(int j=0;j<aenderungen[i].size();j++){
            if((aenderungen[i][j].getBeschreibung()=="") && (aenderungen[i][j].getKurzbeschreibung()=="") && (aenderungen[i][j].getRaum()=="")){
                if(stundenplan[i][aenderungen[i][j].getWochentag()].size()!=0){
                    for(int k=0;k<stundenplan[i][aenderungen[i][j].getWochentag()].size();k++){
                        if(stundenplan[i][aenderungen[i][j].getWochentag()][k].getDoppelstunde()==aenderungen[i][j].getDoppelstunde()){
                            stundenplan[i][aenderungen[i][j].getWochentag()].removeAt(k);
                            break;
                        }
                    }
                }
            }
            else{
                if(stundenplan[i][aenderungen[i][j].getWochentag()].size()!=0){
                    for(int k=0;k<stundenplan[i][aenderungen[i][j].getWochentag()].size();k++){
                        if(stundenplan[i][aenderungen[i][j].getWochentag()][k].getDoppelstunde()==aenderungen[i][j].getDoppelstunde()){
                            stundenplan[i][aenderungen[i][j].getWochentag()].replace(k,aenderungen[i][j]);
                            break;
                        }
                    }
                }
                else{
                    stundenplan[i][aenderungen[i][j].getWochentag()].append(aenderungen[i][j]);
                }
            }
        }
    }
}

void Stundenplan::setGruppe(QString imjahr, QString studieng, QString gr){
    matrikelnummer="";
    imm_jahr=imjahr;
    studiengang=studieng;
    gruppe=gr;
}
void Stundenplan::setMatNr(QString matnr){
    imm_jahr="";
    studiengang="";
    gruppe="";
    matrikelnummer=matnr;
}
void Stundenplan::setAutoUpdate(bool aktiv){
    if(aktiv){
        if((matrikelnummer!="") || ((imm_jahr!="")&&(studiengang!="")&&(gruppe!=""))){
            autoupdate=true;
        }
        else autoupdate=false;
    }
    else autoupdate=false;
}
void Stundenplan::setAutoWriteAenderungen(bool aktiv){
    autowriteaenderungen=aktiv;
}

void Stundenplan::saveSettings(){
    QVariant tmp;
    QVariantList tmplist;
    einstellungen->clear();
    tmp.setValue(autoupdate);
    einstellungen->setValue("AutoUpdate",tmp);
    tmp.setValue(autowriteaenderungen);
    einstellungen->setValue("AutoWriteAenderungen",tmp);
    tmp.setValue(matrikelnummer);
    einstellungen->setValue("MatNr",tmp);
    tmp.setValue(imm_jahr);
    einstellungen->setValue("ImmJahr",tmp);
    tmp.setValue(studiengang);
    einstellungen->setValue("Studiengang",tmp);
    tmp.setValue(gruppe);
    einstellungen->setValue("Gruppe",tmp);
    tmp.setValue(lastupdatekw);
    einstellungen->setValue("LastUpdate",tmp);

    for(int i=0;i<2;i++){
        for(int j=0;j<aenderungen[i].size();j++){
            tmp.setValue(aenderungen[i][j]);
            tmplist.append(tmp);
        }
        if(tmplist.size()>0) {
            einstellungen->setValue("Aenderungen_"+QString().number(i)+"",tmplist);
            tmplist.clear();
        }
    }
    for(int kw=0;kw<2;kw++){
        for(int tage=0;tage<7;tage++){
            for(int i=0;i<stundenplan[kw][tage].size();i++){
                tmp.setValue(stundenplan[kw][tage][i]);
                tmplist.append(tmp);
            }
            if(tmplist.size()>0) {
                einstellungen->setValue("Stundenplan_"+QString().number(kw)+"_"+QString().number(tage),tmplist);
                tmplist.clear();
            }
        }
    }

}
void Stundenplan::readSettings(){
    QVariantList tmplist;
    autoupdate = einstellungen->value("AutoUpdate").toBool();
    autowriteaenderungen = einstellungen->value("AutoWriteAenderungen").toBool();
    matrikelnummer = einstellungen->value("MatNr").toString();
    imm_jahr = einstellungen->value("ImmJahr").toString();
    studiengang = einstellungen->value("Studiengang").toString();
    gruppe = einstellungen->value("Gruppe").toString();
    lastupdatekw = einstellungen->value("LastUpdate").toInt();

    for(int kw=0;kw<2;kw++){
        tmplist = einstellungen->value("Aenderungen_"+QString().number(kw)).value<QVariantList>();
        aenderungen[kw].clear();
        for(int i=0;i<tmplist.size();i++){
            aenderungen[kw].append(tmplist[i].value<StundenplanItem>());
        }
    }
    for(int kw=0;kw<2;kw++){
        for(int tage=0;tage<7;tage++){
            tmplist = einstellungen->value("Stundenplan_"+QString().number(kw)+"_"+QString().number(tage)).value<QVariantList>();
            stundenplan[kw][tage].clear();
            for(int i=0;i<tmplist.size();i++){
                stundenplan[kw][tage].append(tmplist[i].value<StundenplanItem>());
            }
        }
    }
    if(autoupdate){
        if(QDate::currentDate().weekNumber()!=lastupdatekw){
            readPlan();
            if(autowriteaenderungen) writeAllAenderung();
        }
    }
    emit settingsReaded();
}
