#include "settingsdlg.h"
#include "ui_settingsdlg.h"
#include <QRegExp>

SettingsDlg::SettingsDlg(Stundenplan *p, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDlg)
{
    ui->setupUi(this);
    sp = p;
    updateintervall = 60000;
}

SettingsDlg::~SettingsDlg()
{
    delete ui;
}

void SettingsDlg::on_pushButton_clicked()
{
    QRegExp reg("\\d{5}");
    if(reg.exactMatch(ui->lineEdit_matnr->text())){
        sp->readPlan(ui->lineEdit_matnr->text());
    }
}

void SettingsDlg::on_pushButton_2_clicked()
{
    QRegExp reg1("\\d{2}");
    QRegExp reg2("\\d{3}");

    if((reg1.exactMatch(ui->lineEdit_jahr->text())) && (reg2.exactMatch(ui->lineEdit_studiengang->text())) && (reg1.exactMatch(ui->lineEdit_gruppe->text()))){
        sp->readPlan(ui->lineEdit_jahr->text(),ui->lineEdit_studiengang->text(),ui->lineEdit_gruppe->text());
    }

}

/*void SettingsDlg::on_horizontalSlider_valueChanged(int value)
{
    updateintervall = value * 1000 * 60;
}*/

void SettingsDlg::on_horizontalSlider_valueChanged(int value)
{
    updateintervall = value * 1000 * 60;
}
