#include "llabel.h"

LLabel::LLabel(QWidget *parent, Qt::WindowFlags f) :
    QLabel(parent,f)
{
    org = "";
    ltext = "";
    defaultspeed = 1000;
    start_break = 2000;
    end_break = 2000;
    p1 = 0;
    p2 = 0;
    c1 = 0;
    c2 = 0;
    timer = new QTimer();
    connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));

}

LLabel::LLabel(QString str, int speed, QWidget *parent, Qt::WindowFlags f) :
    QLabel(parent,f)
{
    org = "";
    ltext = "";
    defaultspeed = speed;
    start_break = 2000;
    end_break = 2000;
    p1 = 0;
    p2 = 0;
    c1 = 0;
    c2 = 0;
    timer = new QTimer();
    connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));

    setLText(str);

}

int LLabel::getSpeed(){
    return defaultspeed;
}

void LLabel::setSpeed(int speed){
    defaultspeed = speed;
    if(timer->isActive()) {
        timer->stop();
        timer->start(speed);
    }
}

void LLabel::setBreaks(int start, int end){
    start_break = start;
    end_break = end;
}

void LLabel::setLText(QString str){
    setLText(str,defaultspeed);
}

void LLabel::setLText(QString str, int speed){
    if(timer->isActive()) timer->stop();
    p1 = start_break / speed;
    p2 = end_break / speed;
    QFontMetrics fm = this->font();
    if(fm.width(str)>this->width()){
        org = str;
        ltext = str;
        setText(str);
        timer->start(speed);
    }
    else{
        setText(str);
    }
}

void LLabel::timeout(){
    QFontMetrics fm = this->font();
    if(fm.width(ltext)>this->width()){
        c2 = 0;
        if (c1> p1){
            ltext.remove(0,1);
            setText(ltext);
        }
        c1++;
    }
    else{
        c1 = 0;
        if(c2>p2){
            ltext = org;
            setText(ltext);
        }
        c2++;
    }
}
