#ifndef HSADDON_H
#define HSADDON_H

#include <QDeclarativeItem>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QNetworkAccessManager>
#include "common.h"

class hsAddOn : public QDeclarativeItem {
	Q_OBJECT
	Q_PROPERTY(QString name READ name WRITE setName)
	Q_PROPERTY(QString httpReply READ httpReply NOTIFY httpReplyChanged())
	Q_PROPERTY(QDeclarativeListProperty<Task> tasks READ readTasks)

	
public:
	hsAddOn(QDeclarativeItem *parent=0);

	QString name() const;
	void setName(const QString &);
	
	
	QString httpReply() const;
	QDeclarativeListProperty<Task> readTasks();
	
	Q_INVOKABLE void getHttpRessource(const QString &name, const QString &codec);
	Q_INVOKABLE void sendTasks();
	Q_INVOKABLE void addTask(QString author, QString title, QString chanMnemo, QDateTime start, QDateTime stop);
	Q_INVOKABLE QDateTime dateFromString(QString date, QString format);
	
	
public slots:
	void gotReply(QNetworkReply*);
	
signals:
	void httpReplyChanged();
	void finished();
	
	


private:
	QString prv_name;
	QString prv_httpReply;
	QString replCodec;
	QList<Task*> prv_tasks;
};

//to have the implemantation at hand it's placed here
//but it won't be included unless HSADDON_H_DEF is defined
#ifdef HSADDON_H_DEF
hsAddOn::hsAddOn(QDeclarativeItem *parent) : QDeclarativeItem(parent)  {};
QString hsAddOn::name() const {
	return prv_name;
};

void hsAddOn::setName(const QString & val){
	prv_name = val;
};

QString hsAddOn::httpReply() const {
	return prv_httpReply;
};

void hsAddOn::getHttpRessource(const QString &url, const QString &codec){
	QNetworkAccessManager *nwm = new QNetworkAccessManager(this);
	connect(nwm, SIGNAL(finished(QNetworkReply*)),this, SLOT(gotReply(QNetworkReply*)));
	nwm->get(QNetworkRequest(QUrl(url)));
	replCodec = codec;
};

void hsAddOn::gotReply(QNetworkReply* repl){
	QTextCodec *codec = QTextCodec::codecForName(replCodec.toUtf8());
	prv_httpReply = codec->toUnicode(repl->readAll().data());
	emit httpReplyChanged();
};


void hsAddOn::sendTasks(){
	foreach(Task* tk, prv_tasks){
		if(!tk->status)
			continue;
		tk->jobNumber = getNextJobNum();
		tasks.append(*tk);
		QString line = *new QString(tk->title)+ " (" + tk->author+ " " 
			+ tk->chanMnemo + "       " + tk->start.toString("dd.MM.   hh:mm")  + ")";
		hkMain->taskList->addItem(new QListWidgetItem(todoI,line));
		writeTasks();

	}
}

QDeclarativeListProperty<Task> hsAddOn::readTasks() {
	return QDeclarativeListProperty<Task>(this, prv_tasks);
}

void hsAddOn::addTask(QString author, QString title, QString chanMnemo, QDateTime start, QDateTime stop){
	errorS << author << "author" << endl;
	Task* tk = new Task();
	tk->start = start;
	tk->stop = stop;
	tk->author = author;
	tk->title = title;
	tk->chanMnemo = chanMnemo;
	tk->status = DONE;
	prv_tasks.append(tk);
}

QDateTime hsAddOn::dateFromString(QString date, QString format){
	return QDateTime::fromString(date,format);
}

#endif // HSADDON_H_DEF

#endif // HSADDON_H