#include "mainwindow.h"
#include "ui_mainwindow.h"


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    ui->labelUnsupportedKernel->hide();
    ui->quitButtonUnsupported->hide();
    // Connect buttons to functions.
    connectButtons();
    // Make status bar say Ready.
    statusBar()->showMessage(tr("Ready"));
    MainWindow::kernelcheck();
    connect(ui->actionKernel_messages, SIGNAL(triggered()), this, SLOT(kernelmessages())); // kernel messages menu item
}

MainWindow::~MainWindow()
{
    // Restore (mostly) everything to defaults before exiting.
    startbme();
    delete ui;
    system("rm /root/.tempdmesg 2> /dev/null");
}

// About dialog.
void MainWindow::about()
{
    AboutDialog *myAboutDialog = new AboutDialog(this);
    myAboutDialog->show();
}

void MainWindow::connectButtons()
{
    // Menu buttons
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(about()));
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    // Buttons in app.
    connect(ui->hostmodeVBUS, SIGNAL(clicked()), this, SLOT(hostmodeVBUSAction()));
    connect(ui->hostmodeCHARGING, SIGNAL(clicked()), this, SLOT(hostmode()));
    connect(ui->mountButton, SIGNAL(clicked()), this, SLOT(mountdevsda1()));
    connect(ui->vbusDefaultButton, SIGNAL(clicked()), this, SLOT(startbme())); 
}

void MainWindow::mountdevsda1()
{
    system("mkdir -p /media/flash && mount /dev/sda1 /media/flash");
}

void MainWindow::kernelcheck()
{
    system("uname -r > /tmp/.kernelversion");
    QFile file("/tmp/.kernelversion");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&file);
    QString line = in.readLine();
                if (line == "2.6.28-hostmode1") {
                    qDebug() << "Kernel check passed\n";
                } else {
                    qDebug() << "Unsupported kernel detected:" << line;
                    ui->hostmodeCHARGING->hide();
                    ui->hostmodeVBUS->hide();
                    ui->mountButton->hide();
                    ui->vbusDefaultButton->hide();
                    ui->quitButton->hide();
                    ui->labelUnsupportedKernel->show();
                    statusBar()->showMessage(tr("ERROR: Unsupported kernel detected."));
                    ui->quitButtonUnsupported->show();
            #ifdef Q_WS_MAEMO_5
                    QMaemo5InformationBox::information(0, tr("Unsupported kerenl detected"));
            #endif
                }
    }

void MainWindow::hostmode()
{
    qDebug() << "Executing pcsuite-enable.sh\n";
    statusBar()->showMessage(tr("Executing pcsuite-enable.sh"));
    system("/usr/sbin/pcsuite-enable.sh");
    qDebug() << "Stopping BME\n";
    statusBar()->showMessage(tr("Stopping BME"));
    system("stop bme");
    qDebug() << "BME stopped\n";
    qDebug() << "Echoing...\n";
    statusBar()->showMessage(tr("Echoing..."));
    system("echo H > /proc/driver/musb_hdrc && echo host > /sys/devices/platform/musb_hdrc/mode && echo e > /proc/driver/musb_hdrc && echo F > /proc/driver/musb_hdrc && echo host > /sys/devices/platform/musb_hdrc/mode && echo H > /proc/driver/musb_hdrc && echo I > /proc/driver/musb_hdrc && echo host > /sys/devices/platform/musb_hdrc/mode && echo H > /proc/driver/musb_hdrc");
    qDebug() << "Done echoing commands\n";
    statusBar()->showMessage(tr("Done echoing."));
}

// Start BME and reset VBUS to default
void MainWindow::startbme()
{
    qDebug() << "VBUS default clicked\n";
    system("killall vboost.sh 2> /dev/null");
    statusBar()->showMessage(tr("Restoring VBUS to default"));
    system("/usr/sbin/i2cset -y -m 0x01 2 0x6b 0x01 0x00");
    statusBar()->showMessage(tr("Starting BME"));
    system("start bme");
    statusBar()->showMessage(tr("VBUS set to default"));
}

void MainWindow::hostmodeVBUSAction()
{
    qDebug() << "Hostmode VBUS clicked\n";
    hostmode();
    statusBar()->showMessage(tr("Sleeping 1s"));
    sleep(1);
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Starting BME - Connect the USB device NOW'");
    qDebug() << "Starting BME\n"; //(why is this needed?)
    startbme();
    sleep(2);
    qDebug() << "Executing Hostmode VBUS again\n";
    hostmode();
//  system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connect the USB device NOW"")
    sleep(1);
    statusBar()->showMessage(tr("Applying 5V VBUS"));
    system("/root/vboost.sh &");
    statusBar()->showMessage(tr("Commands echoed and 5V VBUS applied"));
}

void MainWindow::kernelmessages()
{
    setWindowFlags(windowFlags() | Qt::Window);
    KernelMessagesWindow *myKernelMessagesWindow = new KernelMessagesWindow(this);
    myKernelMessagesWindow->showLogs();
    myKernelMessagesWindow->show();
}
