#include "items.h"
#include "ui_items.h"
#include <QDir>
#include <QTextStream>
#include <QFile>
#include <QFileInfo>
#include <QListWidgetItem>
#include <QSettings>

#include <glib-2.0/glib-object.h>
//#include <libhildondesktop-1/libhildondesktop/libhildondesktop.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include "locale.h"
//#include <gtk-2.0/gtk/gtk.h>
#include <gtk-2.0/gtk/gtkicontheme.h>

int lugar;

Items::Items(QWidget *parent, int place) :
    QDialog(parent),
    ui(new Ui::Items)
{
    ui->setupUi(this);

    lugar = place;

    QDir dir ( "/usr/share/applications/hildon", "*" );
    dir.setFilter( QDir::Files | QDir::Hidden | QDir::NoDotAndDotDot );
    if ( !dir.isReadable() ) return;

    QListWidgetItem *item0 = new QListWidgetItem( ui->listWidget );
    item0->setIcon(QIcon("/usr/share/icons/hicolor/48x48/hildon/general_exit.png"));
    item0->setText("(remove)");
    item0->setToolTip("REMOVE");
    ui->listWidget->insertItem( 0, item0 );

    QSettings settings2("/etc/hildon/theme/index.theme", QSettings::IniFormat);
    settings2.beginGroup("X-Hildon-Metatheme");
    QString tema = settings2.value("IconTheme", "hicolor").toString();
    tema = tema.trimmed();

    QIcon ic1 = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/general_close.png");
    ui->qsearch->setIcon( ic1 );

    ui->search->setText("");
    ui->swidget->setVisible(false);

    QDirIterator iter("/usr/share/applications/hildon/");
    while(iter.hasNext())
    {
        QString path = iter.next();
        //qDebug() << path;
        if(path.endsWith(".desktop"))
        {
            QSettings settings(path, QSettings::IniFormat);
            settings.beginGroup("Desktop Entry");
            QString name = settings.value("Name", "no name").toString();
            QString icon = settings.value("Icon", "no icon").toString();
            QString type = settings.value("Type", "no icon").toString();

            if ( type == "Application" )
            {
                QString domain("maemo-af-desktop");

                if(settings.contains("X-Text-Domain"))
                    domain = settings.value("X-Text-Domain").toString();

                name = QString::fromUtf8(dgettext(domain.toLatin1(), name.toLatin1()));

                //QIcon icono = QIcon::fromTheme(icon, QIcon(":/images/general_applications.png"));
                QIcon icono = getIcon(icon,tema);

                QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
                item1->setData(Qt::DecorationRole, icono);
                item1->setData(Qt::DisplayRole, name);
                QString temp = QFileInfo(path).fileName();
                temp.replace(".desktop","");
                item1->setToolTip(temp);

                ui->listWidget->insertItem( -1, item1 );
            }
        }
    }


    ui->listWidget->sortItems(Qt::AscendingOrder);

}


Items::~Items()
{
    delete ui;
}

QIcon Items::getIcon(QString icon, QString tema)
{
    QImage icono;

    if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png");

    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png");
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png").exists() )
        icono.load("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png");

    else if ( QFileInfo("/usr/share/pixmaps/" + icon + ".png").exists() )
        icono.load("/usr/share/pixmaps/" + icon + ".png");
    else if ( QFileInfo("/opt/maemo/usr/share/pixmaps/" + icon + ".png").exists() )
        icono.load("/opt/maemo/usr/share/pixmaps/" + icon + ".png");
    else icono.load("/usr/share/icons/hicolor/64x64/hildon/tasklaunch_default_application.png");

    icono = icono.scaled(48, 48, Qt::KeepAspectRatio, Qt::FastTransformation);

    QIcon ficon( QPixmap::fromImage(icono) );
    return ficon;
}


void Items::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QString tip = item->toolTip();
    QSettings settings("cepiperez","homescreen-dockbar");
    QStringList progs = settings.value("Programs",QStringList()).toStringList();

    if ( tip == "REMOVE" )
    {
        progs.removeAt(lugar);
    }
    else
    {
        if ( progs.count() > lugar)
            progs.replace(lugar,tip);
        else
            progs.append(tip);
    }

    settings.setValue("Programs",progs);
    settings.sync();
    this->close();

}

void Items::keyReleaseEvent(QKeyEvent* k)
{
    if ( ui->search->hasFocus()==false )
    {
        ui->swidget->setVisible(true);
        ui->search->setFocus();
        if ( k->key() == 16777219 )
        {
            QString pepe = ui->search->text();
            if ( pepe.length() > 0 ) pepe.remove(pepe.length()-1,1);
            ui->search->setFocus(); ui->search->setText(pepe);
            return;
        }
        else
        {
            ui->search->setText( ui->search->text() + k->text() );
        }
    }

}

void Items::on_search_textChanged(QString filter)
{
    ui->search->setText( ui->search->text().toLower() );
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->text().toLower().indexOf( filter.toLower() )  == -1 )
        {
            ui->listWidget->item(i)->setHidden(true);
        }
        else
        {
            ui->listWidget->item(i)->setHidden(false);
        }
    }
}

void Items::on_qsearch_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
}
