
#include "qesettingsmanager.h"

QSettings *QeSettingsManager::settings = NULL;

void QeSettingsManager::checkSettingsObj()
{
    if (settings == NULL)
        settings = new QSettings();
}

void QeSettingsManager::clearSettings()
{
    checkSettingsObj();
    settings->clear();
}

void QeSettingsManager::storeSetting(const QString& key, const QVariant& value)
{
    checkSettingsObj();
    settings->setValue(key, value);
    settings->sync();
}

void QeSettingsManager::removeSettingsStartingWith(const QString &str)
{
    foreach (QString key, QeSettingsManager::settings->allKeys())
    {
        if (key.startsWith(str))
            QeSettingsManager::settings->remove(key);
    }
}

QVariant QeSettingsManager::retrieveSetting(const QString& key, const QVariant &defaultValue)
{
    checkSettingsObj();
    if (settings->contains(key))
        return settings->value(key);
    return defaultValue;
}


const QSettings *QeSettingsManager::qsettingsInstance()
{
    checkSettingsObj();
    return settings;
}
