// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_TIME_BUTTON_H
#define _HILDONMM_TIME_BUTTON_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/picker-button.h>
#include <hildonmm/time-selector.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTimeButton HildonTimeButton;
typedef struct _HildonTimeButtonClass HildonTimeButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TimeButton_Class; } // namespace Hildon
namespace Hildon
{

/** Button displaying and allowing selection of a time.
 *
 * The TimeButton widget shows a text label and a time, and
 * allows the user to select a different time. Visually, it's a button that,
 * once clicked, presents a Hildon::PickerDialog containing a
 * Hildon::TimeSelector. Once the user selects a different time from the
 * selector, this will be shown in the button.
 *
 * @see Hildon::PickerButton, Hildon::DateButton
 *
 * @ingroup HildonWidgets
 * @ingroup HildonButtons
 */

class TimeButton : public PickerButton
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TimeButton CppObjectType;
  typedef TimeButton_Class CppClassType;
  typedef HildonTimeButton BaseObjectType;
  typedef HildonTimeButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TimeButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TimeButton_Class;
  static CppClassType timebutton_class_;

  // noncopyable
  TimeButton(const TimeButton&);
  TimeButton& operator=(const TimeButton&);

protected:
  explicit TimeButton(const Glib::ConstructParams& construct_params);
  explicit TimeButton(HildonTimeButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTimeButton*       gobj()       { return reinterpret_cast<HildonTimeButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTimeButton* gobj() const { return reinterpret_cast<HildonTimeButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  TimeButton();
  explicit TimeButton(Gtk::Hildon::SizeType size, ButtonArrangement arrangement);

  
  /** Creates a new Hildon::TimeButton. See Hildon::Button::new() for details on the
   * parameters.
   * @param size One of Hildon::SizeType.
   * @param arrangement One of Hildon::ButtonArrangement.
   * @param minutes_step Step between the minutes in the selector options.
   * @return A new Hildon::TimeButton
   * 
   * @newin{2,2}.
   */

  TimeButton(Gtk::Hildon::SizeType size, ButtonArrangement arrangement, guint minutes_step);

  
  /** Sets the time to be displayed in @a button. This time will
   * be selected by default on the Hildon::TimeSelector.
   * 
   * @newin{2,2}
   * @param hours The hours to be set.
   * @param minutes The time to be set.
   */
  void set_time(guint hours, guint minutes);
  
  /** Retrieves the time from @a button.
   * 
   * @newin{2,2}
   * @param hours Return location for the hours of the time selected.
   * @param minutes Return location for the minutes of the time selected.
   */
  void get_time(guint& hours, guint& minutes) const;

  guint get_hours() const;
  guint get_minutes() const;

  // Properly typed forwarding methods:
  inline void set_selector(TimeSelector& selector)
    { PickerButton::set_selector(selector); }
  inline TimeSelector* get_selector()
    { return static_cast<TimeSelector*>(PickerButton::get_selector()); }
  inline const TimeSelector* get_selector() const
    { return static_cast<const TimeSelector*>(PickerButton::get_selector()); }


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::TimeButton
   */
  Hildon::TimeButton* wrap(HildonTimeButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_TIME_BUTTON_H */

