// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_CHECK_BUTTON_H
#define _HILDONMM_CHECK_BUTTON_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/button.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonCheckButton HildonCheckButton;
typedef struct _HildonCheckButtonClass HildonCheckButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class CheckButton_Class; } // namespace Hildon
namespace Hildon
{

/** Button with a check box inside
 *
 * Hildon::CheckButton is a button containing a label and a check box
 * which will remain "pressed-in" when clicked. Clicking again will
 * make the check box toggle its state.
 *
 * The state of a Hildon::CheckButton can be set using
 * Hildon::CheckButton::set_active(), and retrieved using
 * Hildon::CheckButton::get_active(). The label can be set using
 * Gtk::Button::set_label() and retrieved using Gtk::Button::get_label().
 *
 * @note Hildon::CheckButton does not support an image, so don't use
 * Gtk::Button::set_image().
 *
 * @ingroup HildonWidgets
 * @ingroup HildonButtons
 */

class CheckButton : public Gtk::Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef CheckButton CppObjectType;
  typedef CheckButton_Class CppClassType;
  typedef HildonCheckButton BaseObjectType;
  typedef HildonCheckButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~CheckButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class CheckButton_Class;
  static CppClassType checkbutton_class_;

  // noncopyable
  CheckButton(const CheckButton&);
  CheckButton& operator=(const CheckButton&);

protected:
  explicit CheckButton(const Glib::ConstructParams& construct_params);
  explicit CheckButton(HildonCheckButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonCheckButton*       gobj()       { return reinterpret_cast<HildonCheckButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonCheckButton* gobj() const { return reinterpret_cast<HildonCheckButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_toggled();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  CheckButton();
  explicit CheckButton(Gtk::Hildon::SizeType size);

  
  /** Sets the status of a Hildon::CheckButton. Set to <tt>true</tt> if you want
   *  @a button to be 'pressed-in', and <tt>false</tt> to raise it. This action
   * causes the Hildon::CheckButton::toggled signal to be emitted.
   * 
   * @newin{2,2}
   * @param is_active New state for the button.
   */
  void set_active(bool is_active = true);
  
  /** Gets the current state of @a button.
   * @return <tt>true</tt> if @a button is active, <tt>false</tt> otherwise.
   * 
   * @newin{2,2}.
   */
  bool get_active() const;

  
  /** Emits the Hildon::CheckButton::toggled signal on the Hildon::CheckButton.
   * There is no good reason for an application ever to call this function.
   * 
   * @newin{2,2}
   */
  void toggled();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%toggled()</tt>
   */

  Glib::SignalProxy0< void > signal_toggled();


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::CheckButton
   */
  Hildon::CheckButton* wrap(HildonCheckButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_CHECK_BUTTON_H */

