
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <hildonmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "animation-actor.h"
#include "app-menu.h"
#include "banner.h"
#include "button.h"
#include "caption.h"
#include "check-button.h"
#include "date-button.h"
#include "date-selector.h"
#include "edit-toolbar.h"
#include "entry.h"
#include "find-toolbar.h"
#include "note.h"
#include "pannable-area.h"
#include "picker-button.h"
#include "picker-dialog.h"
#include "program.h"
#include "stackable-window.h"
#include "text-view.h"
#include "time-button.h"
#include "time-selector.h"
#include "touch-selector-column.h"
#include "touch-selector-entry.h"
#include "touch-selector.h"
#include "window-stack.h"
#include "window.h"
#include "wizard-dialog.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType hildon_animation_actor_get_type(void);
GType hildon_app_menu_get_type(void);
GType hildon_banner_get_type(void);
GType hildon_button_get_type(void);
GType hildon_caption_get_type(void);
GType hildon_check_button_get_type(void);
GType hildon_date_button_get_type(void);
GType hildon_date_selector_get_type(void);
GType hildon_edit_toolbar_get_type(void);
GType hildon_entry_get_type(void);
GType hildon_find_toolbar_get_type(void);
GType hildon_note_get_type(void);
GType hildon_pannable_area_get_type(void);
GType hildon_picker_button_get_type(void);
GType hildon_picker_dialog_get_type(void);
GType hildon_program_get_type(void);
GType hildon_stackable_window_get_type(void);
GType hildon_text_view_get_type(void);
GType hildon_time_button_get_type(void);
GType hildon_time_selector_get_type(void);
GType hildon_touch_selector_get_type(void);
GType hildon_touch_selector_column_get_type(void);
GType hildon_touch_selector_entry_get_type(void);
GType hildon_window_get_type(void);
GType hildon_window_stack_get_type(void);
GType hildon_wizard_dialog_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Hildon {  class AnimationActor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class AppMenu_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Banner_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Button_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Caption_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class CheckButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class DateButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class DateSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class EditToolbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Entry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class FindToolbar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Note_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class PannableArea_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class PickerButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class PickerDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Program_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class StackableWindow_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TextView_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimeButton_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TimeSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TouchSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TouchSelectorColumn_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class TouchSelectorEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class Window_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WindowStack_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Hildon {  class WizardDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Hildon { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(hildon_animation_actor_get_type(), &Hildon::AnimationActor_Class::wrap_new);
  Glib::wrap_register(hildon_app_menu_get_type(), &Hildon::AppMenu_Class::wrap_new);
  Glib::wrap_register(hildon_banner_get_type(), &Hildon::Banner_Class::wrap_new);
  Glib::wrap_register(hildon_button_get_type(), &Hildon::Button_Class::wrap_new);
  Glib::wrap_register(hildon_caption_get_type(), &Hildon::Caption_Class::wrap_new);
  Glib::wrap_register(hildon_check_button_get_type(), &Hildon::CheckButton_Class::wrap_new);
  Glib::wrap_register(hildon_date_button_get_type(), &Hildon::DateButton_Class::wrap_new);
  Glib::wrap_register(hildon_date_selector_get_type(), &Hildon::DateSelector_Class::wrap_new);
  Glib::wrap_register(hildon_edit_toolbar_get_type(), &Hildon::EditToolbar_Class::wrap_new);
  Glib::wrap_register(hildon_entry_get_type(), &Hildon::Entry_Class::wrap_new);
  Glib::wrap_register(hildon_find_toolbar_get_type(), &Hildon::FindToolbar_Class::wrap_new);
  Glib::wrap_register(hildon_note_get_type(), &Hildon::Note_Class::wrap_new);
  Glib::wrap_register(hildon_pannable_area_get_type(), &Hildon::PannableArea_Class::wrap_new);
  Glib::wrap_register(hildon_picker_button_get_type(), &Hildon::PickerButton_Class::wrap_new);
  Glib::wrap_register(hildon_picker_dialog_get_type(), &Hildon::PickerDialog_Class::wrap_new);
  Glib::wrap_register(hildon_program_get_type(), &Hildon::Program_Class::wrap_new);
  Glib::wrap_register(hildon_stackable_window_get_type(), &Hildon::StackableWindow_Class::wrap_new);
  Glib::wrap_register(hildon_text_view_get_type(), &Hildon::TextView_Class::wrap_new);
  Glib::wrap_register(hildon_time_button_get_type(), &Hildon::TimeButton_Class::wrap_new);
  Glib::wrap_register(hildon_time_selector_get_type(), &Hildon::TimeSelector_Class::wrap_new);
  Glib::wrap_register(hildon_touch_selector_get_type(), &Hildon::TouchSelector_Class::wrap_new);
  Glib::wrap_register(hildon_touch_selector_column_get_type(), &Hildon::TouchSelectorColumn_Class::wrap_new);
  Glib::wrap_register(hildon_touch_selector_entry_get_type(), &Hildon::TouchSelectorEntry_Class::wrap_new);
  Glib::wrap_register(hildon_window_get_type(), &Hildon::Window_Class::wrap_new);
  Glib::wrap_register(hildon_window_stack_get_type(), &Hildon::WindowStack_Class::wrap_new);
  Glib::wrap_register(hildon_wizard_dialog_get_type(), &Hildon::WizardDialog_Class::wrap_new);

  // Register the gtkmm gtypes:
  Hildon::AnimationActor::get_type();
  Hildon::AppMenu::get_type();
  Hildon::Banner::get_type();
  Hildon::Button::get_type();
  Hildon::Caption::get_type();
  Hildon::CheckButton::get_type();
  Hildon::DateButton::get_type();
  Hildon::DateSelector::get_type();
  Hildon::EditToolbar::get_type();
  Hildon::Entry::get_type();
  Hildon::FindToolbar::get_type();
  Hildon::Note::get_type();
  Hildon::PannableArea::get_type();
  Hildon::PickerButton::get_type();
  Hildon::PickerDialog::get_type();
  Hildon::Program::get_type();
  Hildon::StackableWindow::get_type();
  Hildon::TextView::get_type();
  Hildon::TimeButton::get_type();
  Hildon::TimeSelector::get_type();
  Hildon::TouchSelector::get_type();
  Hildon::TouchSelectorColumn::get_type();
  Hildon::TouchSelectorEntry::get_type();
  Hildon::Window::get_type();
  Hildon::WindowStack::get_type();
  Hildon::WizardDialog::get_type();

} // wrap_init()

} //Hildon


