// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_PICKER_DIALOG_H
#define _HILDONMM_PICKER_DIALOG_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/dialog.h>
#include <hildonmm/touch-selector.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonPickerDialog HildonPickerDialog;
typedef struct _HildonPickerDialogClass HildonPickerDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class PickerDialog_Class; } // namespace Hildon
namespace Hildon
{

/** A utility dialog that shows a Hildon::TouchSelector widget.
 *
 * Hildon::PickerDialog is a dialog that is used to show a
 * Hildon::TouchSelector widget and a "Done" button to allow users to finish
 * their selections.
 *
 * The PickerDialog will show a "Done" button in case the
 * Hildon::TouchSelector allows multiple selection. The label of the button can
 * be set using Hildon::PickerDialog::set_done_label() and retrieved using
 * Hildon::PickerDialog::get_done_label().
 *
 * Note that in most cases developers don't need to deal directly with this
 * dialog. Hildon::PickerButton is designed to pop up a Hildon::PickerDialog
 * and manage the interaction with it.
 *
 * @ingroup HildonDialogs
 */

class PickerDialog : public Gtk::Dialog
{
  // Note that, in the C API, HildonPickerDialog actually derives from the
  // deprecated HildonDialog, which in turn derives from GtkDialog.  This is
  // not exposed in the C++ API, and Hildon::PickerDialog derives directly
  // from Gtk::Dialog.  For prior art, see Gtk::ProgressBar.
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PickerDialog CppObjectType;
  typedef PickerDialog_Class CppClassType;
  typedef HildonPickerDialog BaseObjectType;
  typedef HildonPickerDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~PickerDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class PickerDialog_Class;
  static CppClassType pickerdialog_class_;

  // noncopyable
  PickerDialog(const PickerDialog&);
  PickerDialog& operator=(const PickerDialog&);

protected:
  explicit PickerDialog(const Glib::ConstructParams& construct_params);
  explicit PickerDialog(HildonPickerDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonPickerDialog*       gobj()       { return reinterpret_cast<HildonPickerDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonPickerDialog* gobj() const { return reinterpret_cast<HildonPickerDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  PickerDialog();

  
  /** Creates a new Hildon::PickerButton. See Hildon::Button::new() for details on the
   * parameters.
   * @param size One of Hildon::SizeType, specifying the size of the new button.
   * @param arrangement One of Hildon::ButtonArrangement, specifying the placement of the
   * labels.
   * @return A newly created Hildon::PickerButton
   * 
   * @newin{2,2}.
   */

  explicit PickerDialog(Gtk::Window& parent);

  
  /** Sets @a selector as the Hildon::TouchSelector to be shown in @a dialog
   * @param selector A Hildon::TouchSelector.
   * @return <tt>true</tt> if @a selector was set, <tt>false</tt> otherwise
   * 
   * @newin{2,2}.
   */
  void set_selector(TouchSelector& selector);
  
  /** Retrieves the Hildon::TouchSelector associated to @a dialog.
   * @return A Hildon::TouchSelector
   * 
   * @newin{2,2}.
   */
  TouchSelector* get_selector();
  
  /** Retrieves the Hildon::TouchSelector associated to @a dialog.
   * @return A Hildon::TouchSelector
   * 
   * @newin{2,2}.
   */
  const TouchSelector* get_selector() const;

  
  /** Sets a custom string to be used as the 'Done' button label in @a dialog.
   * 
   * @newin{2,2}
   * @param label A string.
   */
  void set_done_label(const Glib::ustring& label);
  
  /** Retrieves current 'Done' button label.
   * @return The custom string to be used.
   * 
   * @newin{2,2}.
   */
  Glib::ustring get_done_label() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Done Button Label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_done_button_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Done Button Label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_done_button_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the dialog should center on the current selection when it is showed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_center_on_show() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the dialog should center on the current selection when it is showed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_center_on_show() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:  
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_selector_vfunc(TouchSelector* selector);
#endif //GLIBMM_VFUNCS_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::PickerDialog
   */
  Hildon::PickerDialog* wrap(HildonPickerDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_PICKER_DIALOG_H */

