// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_WINDOW_STACK_H
#define _HILDONMM_WINDOW_STACK_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/stackable-window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonWindowStack HildonWindowStack;
typedef struct _HildonWindowStackClass HildonWindowStackClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class WindowStack_Class; } // namespace Hildon
namespace Hildon
{

/** A stack of windows in the Hildon framework.
 *
 * Stacks contain all Hildon::StackableWindow instances that are being shown.
 * The user can only interact with the topmost window from each stack (as it
 * covers all the others), but all of them are mapped and visible from the GTK+
 * point of view.
 *
 * Each window can only be in one stack at a time. All stacked windows are
 * visible and all visible windows are stacked.  Each application has a default
 * stack, and windows are automatically added to it when they are shown with
 * Gtk::Widget::show().
 *
 * Additional stacks can be created at any time using
 * Hildon::WindowStack::create(). To add a window to a specific stack, use
 * Hildon::WindowStack::push() (remember that, for the default stack,
 * Gtk::Widget::show() can be used instead).
 *
 * To remove a window from a stack use Hildon::WindowStack::pop(), or simply
 * Gtk::Widget::hide().
 *
 * For more complex layout changes, applications can push and/or pop several
 * windows at the same time in a single step. See Hildon::WindowStack::push(),
 * Hildon::WindowStack::pop() and Hildon::WindowStack::pop_and_push() for more
 * details.
 */

class WindowStack : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef WindowStack CppObjectType;
  typedef WindowStack_Class CppClassType;
  typedef HildonWindowStack BaseObjectType;
  typedef HildonWindowStackClass BaseClassType;

private:  friend class WindowStack_Class;
  static CppClassType windowstack_class_;

private:
  // noncopyable
  WindowStack(const WindowStack&);
  WindowStack& operator=(const WindowStack&);

protected:
  explicit WindowStack(const Glib::ConstructParams& construct_params);
  explicit WindowStack(HildonWindowStack* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~WindowStack();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  HildonWindowStack*       gobj()       { return reinterpret_cast<HildonWindowStack*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const HildonWindowStack* gobj() const { return reinterpret_cast<HildonWindowStack*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  HildonWindowStack* gobj_copy();

private:


protected:
  WindowStack();

public:
  /** Create a new WindowStack. The WindowStack is initally empty.
   *
   * @returns A new WindowStack.
   */
  
  static Glib::RefPtr<WindowStack> create();


  /** Return value: the default Hildon::WindowStack
   * @return The default Hildon::WindowStack
   * 
   * @newin2p2.
   */
  static Glib::RefPtr<WindowStack> get_default();

  
  /** Return value: Number of windows in @a stack
   * @return Number of windows in @a stack
   * 
   * @newin2p2.
   */
  int size() const;

  //TODO: Documentation:
  bool empty() const;

  
  /** Return value: the window on top of the stack, or <tt>0</tt> if the stack
   * @return The window on top of the stack, or <tt>0</tt> if the stack
   * is empty.
   * 
   * @newin2p2.
   */
  StackableWindow* top() const;
  
  /** Adds @a win to the top of @a stack, and shows it. The window must not
   * be already stacked.
   * 
   * @newin2p2
   * @param win A Hildon::StackableWindow.
   */
  void push(StackableWindow* win);
  
  /** Removes the window on top of @a stack, and hides it. If the stack is
   * empty nothing happens.
   * @return The window on top of the stack, or <tt>0</tt> if the stack
   * is empty.
   * 
   * @newin2p2.
   */
  StackableWindow* pop();

  
  /** Pushes all windows in @a list to the top of @a stack, and shows
   * them. Everything is done in a single transition, so the user will
   * only see the last window in @a list during this operation. None of
   * the windows must be already stacked.
   * 
   * @newin2p2
   * @param list A list of Hildon::StackableWindow<!-- -->s to push.
   */
  void push(const Glib::ListHandle<StackableWindow*>& list);

  
  /** Pops @a nwindows windows from @a stack, and hides them. Everything is
   * done in a single transition, so the user will not see any of the
   * windows being popped in this operation.
   * 
   * If @a popped_windows is not <tt>0</tt>, the list of popped windows is
   * stored there (ordered bottom-up). That list must be freed by the
   * user.
   * 
   * @newin2p2
   * @param nwindows Number of windows to pop.
   * @param popped_windows If non-<tt>0</tt>, the list of popped windows is stored here.
   */

  Glib::ListHandle<StackableWindow*> pop(int nwindows);

  
  /** Pops @a nwindows windows from @a stack (and hides them), then pushes
   * all windows in @a list (and shows them). Everything is done in a
   * single transition, so the user will only see the last window from
   *  @a list. None of the pushed windows must be already stacked.
   * 
   * If @a popped_windows is not <tt>0</tt>, the list of popped windows is
   * stored there (ordered bottom-up). That list must be freed by the
   * user.
   * 
   * @newin2p2
   * @param nwindows Number of windows to pop.
   * @param popped_windows If non-<tt>0</tt>, the list of popped windows is stored here.
   * @param list A list of Hildon::StackableWindow<!-- -->s to push.
   */

  Glib::ListHandle<StackableWindow*>
  pop_and_push(int nwindows, const Glib::ListHandle<StackableWindow*>& list);

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::WindowStack
   */
  Glib::RefPtr<Hildon::WindowStack> wrap(HildonWindowStack* object, bool take_copy = false);
}


#endif /* _HILDONMM_WINDOW_STACK_H */

