// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_STACKABLE_WINDOW_H
#define _HILDONMM_STACKABLE_WINDOW_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonStackableWindow HildonStackableWindow;
typedef struct _HildonStackableWindowClass HildonStackableWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class StackableWindow_Class; } // namespace Hildon
namespace Hildon
{

class WindowStack;

/** This widget is a stackable top-level window in the Hildon framework, 
 * derived from Hildon::Window.
 *
 * Applications that
 * use stackable windows are organized in a hierarchical way so users can go
 * from any window back to the application's root window.
 *
 * The user can only see and interact with the window on top of the stack.
 * Although all other windows are mapped and visible, they are obscured by the
 * topmost one so in practice they appear as if they were hidden.
 *
 * To add a window to the stack, just use Gtk::Widget::show(). The previous one
 * will be obscured by the new one. When the new window is destroyed, the
 * previous one will appear again.
 *
 * Alternatively, you can remove a window from the top of the stack without
 * destroying it by using Hildon::WindowStack::pop(). The window will be
 * automatically hidden and the previous one will appear.
 *
 * For advanced details on stack handling, see Hildon::WindowStack.
 *
 * @see Hildon::WindowStack, Hildon::Program, Hildon::Window
 */

class StackableWindow : public Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef StackableWindow CppObjectType;
  typedef StackableWindow_Class CppClassType;
  typedef HildonStackableWindow BaseObjectType;
  typedef HildonStackableWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~StackableWindow();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class StackableWindow_Class;
  static CppClassType stackablewindow_class_;

  // noncopyable
  StackableWindow(const StackableWindow&);
  StackableWindow& operator=(const StackableWindow&);

protected:
  explicit StackableWindow(const Glib::ConstructParams& construct_params);
  explicit StackableWindow(HildonStackableWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonStackableWindow*       gobj()       { return reinterpret_cast<HildonStackableWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonStackableWindow* gobj() const { return reinterpret_cast<HildonStackableWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

   
public:
  StackableWindow();

  
  /** Return value: a Hildon::WindowStack, or <tt>0</tt>
   * @return A Hildon::WindowStack, or <tt>0</tt>
   * 
   * @newin2p2.
   */
  Glib::RefPtr<WindowStack> get_stack();
  
  /** Return value: a Hildon::WindowStack, or <tt>0</tt>
   * @return A Hildon::WindowStack, or <tt>0</tt>
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const WindowStack> get_stack() const;


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::StackableWindow
   */
  Hildon::StackableWindow* wrap(HildonStackableWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_STACKABLE_WINDOW_H */

