// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_ENTRY_H
#define _HILDONMM_ENTRY_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/entry.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonEntry HildonEntry;
typedef struct _HildonEntryClass HildonEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Entry_Class; } // namespace Hildon
namespace Hildon
{

/** A text entry widget.
 *
 * Hildon::Entry is a text entry. It is derived from
 * Gtk::Entry and provides additional commodities specific to the Hildon
 * framework.
 *
 * Besides all the features inherited from Gtk::Entry, a Hildon::Entry can also
 * have a placeholder text. This text will be shown if the entry is empty and
 * doesn't have the input focus, but is otherwise ignored. Thus, calls to
 * Hildon::Entry::get_text() will never return the placeholder text, not even
 * when it's being displayed.
 *
 * Although Hildon::Entry is derived from Gtk::Entry, Gtk::Entry::get_text()
 * and Gtk::Entry::set_text() must never be used to get/set the text in this
 * widget. Hildon::Entry::get_text() and Hildon::Entry::set_text() must be used
 * instead.
 *
 * @ingroup HildonWidgets
 */

class Entry : public Gtk::Entry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Entry CppObjectType;
  typedef Entry_Class CppClassType;
  typedef HildonEntry BaseObjectType;
  typedef HildonEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Entry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Entry_Class;
  static CppClassType entry_class_;

  // noncopyable
  Entry(const Entry&);
  Entry& operator=(const Entry&);

protected:
  explicit Entry(const Glib::ConstructParams& construct_params);
  explicit Entry(HildonEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonEntry*       gobj()       { return reinterpret_cast<HildonEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonEntry* gobj() const { return reinterpret_cast<HildonEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  explicit Entry(Gtk::Hildon::SizeType size);

  
  /** Sets the text in @a entry to @a text, replacing its current contents.
   * 
   * Note that you must never use gtk_entry_set_text() to set the text
   * of a Hildon::Entry.
   * 
   * @newin2p2
   * @param text The new text.
   */
  void set_text(const Glib::ustring& text);
  
  /** Gets the current text in @a entry.
   * 
   * Note that you must never use gtk_entry_get_text() to get the text
   * from a Hildon::Entry.
   * 
   * Also note that placeholder text (set using
   * set_placeholder()) is never returned. Only text set by
   * set_text() or typed by the user is considered.
   * @return The text in @a entry. This text must not be modified or
   * freed.
   * 
   * @newin2p2.
   */
  Glib::ustring get_text() const;

  
  /** Sets the placeholder text in @a entry to @a text.
   * 
   * @newin2p2
   * @param text The new text.
   */
  void set_placeholder(const Glib::ustring& text);


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Entry
   */
  Hildon::Entry* wrap(HildonEntry* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_ENTRY_H */

