// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_BANNER_H
#define _HILDONMM_BANNER_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/window.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/label.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonBanner HildonBanner;
typedef struct _HildonBannerClass HildonBannerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Banner_Class; } // namespace Hildon
namespace Hildon
{

/** @defgroup HildonWidgets Widgets
 */

/** A widget used to display timed notifications. 
 *
 * Hildon::Banner is a small pop-up window that can be used to display a short,
 * timed notification or information to the user. It can communicate that a
 * task has been finished or that the application state has changed.
 *
 * Hildon provides convenient funtions to create and show banners. To create
 * and show information banners you can use Hildon::Banner::show_information(),
 * or Hildon::Banner::show_information_with_markup().
 *
 * Information banners dissapear automatically after a certain period. This is
 * stored in Hildon::Banner::property_timeout() (in miliseconds), and can be
 * changed using Hildon::Banner::set_timeout().
 *
 * Note that Hildon::Banner<!-- -->s should only be used to display
 * non-critical pieces of information.
 *
 * @ingroup HildonDialogs
 */

class Banner : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Banner CppObjectType;
  typedef Banner_Class CppClassType;
  typedef HildonBanner BaseObjectType;
  typedef HildonBannerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Banner();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Banner_Class;
  static CppClassType banner_class_;

  // noncopyable
  Banner(const Banner&);
  Banner& operator=(const Banner&);

protected:
  explicit Banner(const Glib::ConstructParams& construct_params);
  explicit Banner(HildonBanner* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonBanner*       gobj()       { return reinterpret_cast<HildonBanner*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonBanner* gobj() const { return reinterpret_cast<HildonBanner*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


protected:
  Banner();

public:
  //TODO: Should this be deleted?
  //See https://bugs.maemo.org/show_bug.cgi?id=4643

  /** Create and display a banner.
   * This method creates and displays an information banner that
   * automatically goes away after a certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   *
   * @param widget The widget that wants to display a banner.
   * @param text The text to display.
   */
  static Banner* show_information(Gtk::Widget& widget, const Glib::ustring& text);

  /** Create and display a banner.
   * This method creates and displays an information banner that
   * automatically goes away after a certain time period. For each window
   * in your application there can only be one timed banner, so if you
   * spawn a new banner before the earlier one has timed out, the
   * previous one will be replaced.
   *
   * @param widget The widget that wants to display a banner.
   * @param markup A markup string to display (see
   *  <a href="http://library.gnome.org/devel/pango/stable/PangoMarkupFormat.html">Text Attribute Markup</a>).
   * @returns The newly created banner.
   */
  static Banner* show_information_with_markup(Gtk::Widget& widget, const Glib::ustring& markup);	
		
  
  /** Sets the text that is displayed in the banner.
   * @param text A new text to display in banner.
   */
  void set_text(const Glib::ustring& text);
  
  /** Sets the text with markup that is displayed in the banner.
   * @param markup A new text with Pango markup to display in the banner.
   */
  void set_markup(const Glib::ustring& markup);

   //deprecated.
  
  
  /** Sets the timeout on the banner. After the given amount of miliseconds
   * has elapsed the banner will be destroyed. Setting this only makes
   * sense on banners that are timed and that have not been yet displayed
   * on the screen.
   * 
   * Note that this method only has effect if @a self is an information
   * banner, created using show_information() and show_information_with_markup().
   * @param timeout Timeout to set in miliseconds.
   */
  void set_timeout(guint timeout);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The window for which the banner will be singleton.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Window*> property_parent_window() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the notification goes away automatically after the specified time has passed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_timed() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The time before making the banner banner go away.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Banner
   */
  Hildon::Banner* wrap(HildonBanner* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_BANNER_H */

