// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_APP_MENU_H
#define _HILDONMM_APP_MENU_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/button.h>
#include <gtkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonAppMenu HildonAppMenu;
typedef struct _HildonAppMenuClass HildonAppMenuClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class AppMenu_Class; } // namespace Hildon
namespace Hildon
{

/** The application menu in the Hildon framework.
 *
 * This menu opens from the top of the screen and contains a number of
 * entries (Gtk::Button) organized in one or two columns, depending on
 * the size of the screen (the number of columns changes automatically
 * if the screen is resized). Entries are added left to right and top
 * to bottom.
 *
 * Besides that, the Hildon::AppMenu can contain a group of filter buttons
 * (Gtk::ToggleButton or Gtk::RadioButton).
 *
 * To use a Hildon::AppMenu, add it to a Hildon::Window using
 * Hildon::Window::set_app_menu(). The menu will appear when the user
 * presses the window title bar. Alternatively, you can show it by
 * hand using Hildon::AppMenu::popup().
 *
 * The menu will be automatically hidden when one of its buttons is
 * clicked.
 *
 * @ingroup HildonWidgets
 */

class AppMenu : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AppMenu CppObjectType;
  typedef AppMenu_Class CppClassType;
  typedef HildonAppMenu BaseObjectType;
  typedef HildonAppMenuClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AppMenu();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AppMenu_Class;
  static CppClassType appmenu_class_;

  // noncopyable
  AppMenu(const AppMenu&);
  AppMenu& operator=(const AppMenu&);

protected:
  explicit AppMenu(const Glib::ConstructParams& construct_params);
  explicit AppMenu(HildonAppMenu* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonAppMenu*       gobj()       { return reinterpret_cast<HildonAppMenu*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonAppMenu* gobj() const { return reinterpret_cast<HildonAppMenu*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

 
public:
  AppMenu();

  
  /** Adds @a item to the end of the menu's item list.
   * 
   * @newin2p2
   * @param item A Gtk::Button to add to the Hildon::AppMenu.
   */
  void append(Gtk::Button& item);
  
  /** Adds @a item to the beginning of the menu's item list.
   * 
   * @newin2p2
   * @param item A Gtk::Button to add to the Hildon::AppMenu.
   */
  void prepend(Gtk::Button& item);
  
  /** Adds @a item to @a menu at the position indicated by @a position.
   * 
   * @newin2p2
   * @param item A Gtk::Button to add to the Hildon::AppMenu.
   * @param position The position in the item list where @a item is added (from 0 to n-1).
   */
  void insert(Gtk::Button& item, int position);
  
  /** Moves a Gtk::Button to a new position within Hildon::AppMenu.
   * 
   * @newin2p2
   * @param item A Gtk::Button to move.
   * @param position The new position to place @a item (from 0 to n-1).
   */
  void reorder_child(Gtk::Button& item, int position);
  
  /** Adds the @a filter to @a menu.
   * 
   * @newin2p2
   * @param filter A Gtk::Button to add to the Hildon::AppMenu.
   */
  void add_filter(Gtk::Button& filter);

  
  /** Displays a menu on top of a window and makes it available for
   * selection.
   * 
   * @newin2p2
   * @param parent_window A Gtk::Window.
   */
  void popup(Gtk::Window& parent_window);
  

  /** Returns: a newly-allocated list containing the items in @a menu
   * @return A newly-allocated list containing the items in @a menu
   * 
   * @newin2p2.
   */
  Glib::ListHandle<Gtk::Button*> get_items();
  
  /** Returns: a newly-allocated list containing the items in @a menu
   * @return A newly-allocated list containing the items in @a menu
   * 
   * @newin2p2.
   */
  Glib::ListHandle<const Gtk::Button*> get_items() const;
               
  
  /** Returns: a newly-allocated list containing the filters in @a menu
   * @return A newly-allocated list containing the filters in @a menu
   * 
   * @newin2p2.
   */
  Glib::ListHandle<Gtk::Button*> get_filters();
  
  /** Returns: a newly-allocated list containing the filters in @a menu
   * @return A newly-allocated list containing the filters in @a menu
   * 
   * @newin2p2.
   */
  Glib::ListHandle<const Gtk::Button*> get_filters() const;


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::AppMenu
   */
  Hildon::AppMenu* wrap(HildonAppMenu* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_APP_MENU_H */

