// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_CAPTION_H
#define _HILDONMM_CAPTION_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/eventbox.h>
#include <gtkmm/sizegroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonCaption HildonCaption;
typedef struct _HildonCaptionClass HildonCaptionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Caption_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum CaptionStatus
{
  CAPTION_OPTIONAL,
  CAPTION_MANDATORY
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::CaptionStatus> : public Glib::Value_Enum<Hildon::CaptionStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildonmmEnums
 */
enum CaptionIconPosition
{
  CAPTION_POSITION_LEFT,
  CAPTION_POSITION_RIGHT
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::CaptionIconPosition> : public Glib::Value_Enum<Hildon::CaptionIconPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** Hildon::Caption is a single-child container widget that precedes the 
 * contained widget with a field label and an optional icon, allowing grouping 
 * of several controls together. When a captioned widget has focus, 
 * both the widget and the caption label are displayed with active focus. 
 *
 * @ingroup HildonWidgets
 */

class Caption : public Gtk::EventBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Caption CppObjectType;
  typedef Caption_Class CppClassType;
  typedef HildonCaption BaseObjectType;
  typedef HildonCaptionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Caption();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Caption_Class;
  static CppClassType caption_class_;

  // noncopyable
  Caption(const Caption&);
  Caption& operator=(const Caption&);

protected:
  explicit Caption(const Glib::ConstructParams& construct_params);
  explicit Caption(HildonCaption* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonCaption*       gobj()       { return reinterpret_cast<HildonCaption*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonCaption* gobj() const { return reinterpret_cast<HildonCaption*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_activate();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  
  explicit Caption(CaptionStatus flag = CAPTION_OPTIONAL);

  Caption(const Glib::RefPtr<Gtk::SizeGroup>& group, const Glib::ustring& value,
          Gtk::Widget& child, Gtk::Widget& icon, CaptionStatus flag = CAPTION_OPTIONAL);

  Caption(const Glib::ustring& value, Gtk::Widget& child, Gtk::Widget& icon,
          CaptionStatus flag = CAPTION_OPTIONAL);

  Caption(const Glib::ustring& value, Gtk::Widget& child,
          CaptionStatus flag = CAPTION_OPTIONAL);

  
  /** Query given captioned control for the Gtk::SizeGroup assigned to it.
   * 
   *  @a Returns : a Gtk::SizeGroup
   */
  Glib::RefPtr<Gtk::SizeGroup>  get_size_group();
  
  /** Query given captioned control for the Gtk::SizeGroup assigned to it.
   * 
   *  @a Returns : a Gtk::SizeGroup
   */
  Glib::RefPtr<const Gtk::SizeGroup>  get_size_group() const;
  
  /** Sets a Gtk::SizeGroup of a given captioned control.
   * @param new_group A Gtk::SizeGroup.
   */
  void set_size_group(const Glib::RefPtr<Gtk::SizeGroup>& new_group);

  
  /** Query Hildon::Caption whether this captioned control is a mandatory one.
   * 
   *  @a Returns : is this captioned control a mandatory one?
   */
  bool is_mandatory() const;
  
  /** Sets Hildon::Caption status.
   * @param flag One of the values from Hildon::CaptionStatus.
   */
  void set_status(CaptionStatus flag);
  
  /** Gets Hildon::Caption status.
   * 
   *  @a Returns : one of the values from Hildon::CaptionStatus
   */
  CaptionStatus get_status() const;

  
  /** Sets Hildon::Caption icon position.
   * @param pos One of the values from Hildon::CaptionIconPosition.
   */
  void set_icon_position(CaptionIconPosition pos);
  
  /** Gets Hildon::Caption icon position.
   * 
   *  @a Returns : one of the values from Hildon::CaptionIconPosition.
   */
  CaptionIconPosition get_icon_position() const;

  // The icon can actually be any Gtk::Widget; it does not need to be a Gtk::Image.
  
  /** Sets the icon image widget to be used by this hildon_caption widget.
   * @param icon The Gtk::Image to use as the icon. 
   * calls gtk_widget_show on the icon if !GTK_WIDGET_VISIBLE(icon).
   */
  void set_icon_image(Gtk::Widget& icon);
  
  /** Gets icon of Hildon::Caption
   * 
   *  @a Returns : the Gtk::Image widget that is being used as the icon by the
   * hildon_caption, or <tt>0</tt> if no icon image is in use.
   */
  Gtk::Widget* get_icon_image();
  
  /** Gets icon of Hildon::Caption
   * 
   *  @a Returns : the Gtk::Image widget that is being used as the icon by the
   * hildon_caption, or <tt>0</tt> if no icon image is in use.
   */
  const Gtk::Widget* get_icon_image() const;

  
  /** Sets the label text that appears before the control.  
   * Separator character is added to the end of the label string. By default
   * the separator is ":".
   * @param label The text to use.
   */
  void set_label(const Glib::ustring& label);
  
  /** Gets label of Hildon::Caption
   * 
   *  @a Returns : the text currently being used as the label of the caption
   * control.
   */
  Glib::ustring get_label() const;

  
  /** Sets the separator character that appears after the label.  
   * The default seaparator character is ":"
   * separately.
   * @param separator The separator to use.
   */
  void set_separator(const Glib::ustring& separator);
  
  /** Gets separator string of Hildon::Caption
   * 
   *  @a Returns : the text currently being used as the separator of the caption
   * control.
   */
  Glib::ustring get_separator() const;

  
  /** Sets the vertical alignment to be used for the
   * text part of the caption. Applications need to
   * align the child control themselves.
   * @param alignment New vertical alignment.
   */
  void set_label_alignment(float alignment);
  
  /** Gets current vertical alignment for the text part.
   * @return Vertical alignment.
   */
  float get_label_alignment() const;

  
  /** Sets child expandability.
   * @param expand <tt>bool</tt> to determine if the child is expandable.
   */
  void set_child_expand(bool expand = true);
  
  /** Gets childs expandability.
   * 
   *  @a Returns : wheter the child is expandable or not.
   */
  bool get_child_expand() const;

  
  /** Sets the label markup text that appears before the control. It acts like
   * #hildon_caption_set_label but is using the markup text that allows to specify
   * text properties such as bold or italic.
   * @param markup The markup text to use.
   */
  void set_label_markup(const Glib::ustring& markup);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Caption label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Caption label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Caption markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon shown on the caption area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Widget*> property_icon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon shown on the caption area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Widget*> property_icon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Mandatory or optional status.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<CaptionStatus> property_status() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Mandatory or optional status.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<CaptionStatus> property_status() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the icon is on the left or right side.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<CaptionIconPosition> property_icon_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the icon is on the left or right side.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<CaptionIconPosition> property_icon_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current size group the caption is in.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gtk::SizeGroup> > property_size_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current size group the caption is in.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gtk::SizeGroup> > property_size_group() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Current separator.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_separator() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Current separator.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_separator() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Caption
   */
  Hildon::Caption* wrap(HildonCaption* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_CAPTION_H */

