// -*- c++ -*-
#ifndef _HILDONMM_TOUCH_SELECTOR_ENTRY_TEXT_H
#define _HILDONMM_TOUCH_SELECTOR_ENTRY_TEXT_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/touch-selector-entry.h>
#include <gtkmm/liststore.h>

namespace Hildon
{

class TouchSelectorEntryText
: public TouchSelectorEntry
{
#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // noncopyable
  TouchSelectorEntryText(const TouchSelectorEntryText&);
  TouchSelectorEntryText& operator=(const TouchSelectorEntryText&);

protected:
  explicit TouchSelectorEntryText(const Glib::ConstructParams& construct_params);
  explicit TouchSelectorEntryText(HildonTouchSelectorEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  TouchSelectorEntryText();

  /** Add an item to the end of the drop-down list.
   * @param text The text for the item.
   */
  void append_text(const Glib::ustring& text);

  void insert_text(int position, const Glib::ustring& text);

  /** Add an item to the beginning of the drop-down list.
   * @param text The text for the item.
   */
  void prepend_text(const Glib::ustring& text);

  /** Get the currently-chosen item.
   * @result The text of the active item.
   */
  Glib::ustring get_active_text() const;

  /** Set the currently-chosen item if it matches the specified text.
   * @text The text of the item that should be selected.
   */
  void set_active_text(const Glib::ustring& text);

  //There is a clear() method in the CellLayout base class, so this would cause confusion.
  //TODO: Remove this when we can break API.
  /// @deprecated See clear_items(). Since 2.8.
  void clear();

  /** Remove all items from the drop-down menu.
   */
  void clear_items();

  /** Remove the specified item if it is in the drop-down menu.
   * @text The text of the item that should be removed.
   */
  void remove_text(const Glib::ustring& text);

protected:

  //Tree model columns:
  //These columns are used by the model that is created by the default constructor
  class TextModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    TextModelColumns()
    { add(m_column); }

    Gtk::TreeModelColumn<Glib::ustring> m_column;
  };

  TextModelColumns m_text_columns;

  Glib::RefPtr<Gtk::ListStore> m_model;

  Glib::RefPtr<TouchSelectorColumn> m_touch_selector_column;
};

} //namespace Hildon


#endif /* _HILDONMM_TOUCH_SELECTOR_ENTRY_TEXT_H */

